--[[
Wardrobe Plus
Allows adding new Designs to the Ingame Wardrobe

Copyright (C) [F/A]braeven

Author: braeven
Date: 02.06.2024
Version: 2.0.3.0

Contact/Help
https://github.com/braeven/FS22_Production_Revamp
Or Production Revamp Discord / Maize Plus Discord


Changelog:
0.1.0.0 @ 11.04.2023 - First Test
0.2.0.0 @ 15.04.2023 - Added Female Variants, fix initial bug that required switching model to view new clothes
0.3.0.0 @ 16.04.2023 - Added Multiple Instances Support
0.4.0.0 @ 21.04.2023 - PlayerStyle saved in the GameSettings should be reloaded
0.5.0.0 @ 22.04.2023 - Reduced Filesizes, made overview-icons change between male/female
0.6.0.0 @ 28.04.2023 - Major rewrite
0.7.0.0 @ 29.04.2023 - Some Fixes, Rename
1.0.0.0 @ 09.05.2023 - Release Version
2.0.0.0 Alpha 1 @ 11.06.2023 - Added Aviator jacket as option
2.0.0.0 Alpha 2 @ 09.08.2023 - Added options to disable color/set a custom color
2.0.0.0 Alpha 3 @ 10.08.2023 - Major rework to allow more customisation
2.0.0.0 Alpha 4 @ 10.08.2023 - Added Cowboy, Fisher and Outback-Hat, Added Windbreaker, Construction, and Workjacket as new option
2.0.0.0 Alpha 5 @ 12.08.2023 - Added even more Options
2.0.0.0 Alpha 6 @ 12.08.2023 - Some rewrites again
2.0.0.0 Alpha 7 @ 13.08.2023 - Some fixes
2.0.0.0 Alpha 8 @ 13.08.2023 - Added support for pants
2.0.0.0 Alpha 9 @ 16.08.2023 - Added remaining tops
2.0.0.0 Alpha 10 @ 17.08.2023 - Bugfixes, some Rework
2.0.0.0 Beta 1 @ 19.08.2023 - Colorchoice is now working, fixed WOOLCOATFEMALE and PUFFJACKET
2.0.0.0 Beta 2 @ 19.08.2023 - Fixed using secondary colors
2.0.0.0 Beta 3 @ 19.08.2023 - Updated Samplemod
2.0.0.0 @ 18.09.2023 - Release Version 2
2.0.0.1 @ 06.11.2023 - Bugfix Workjacket
2.0.1.0 @ 30.05.2024 - Added some Compability, Optimisation
2.0.2.0 @ 30.05.2024 - Added some more Compability
2.0.3.0 @ 02.06.2024 - Added some more Compability


Important:
No changes are allowed to this script without permission from Braeven.
Don't copy the script into a mod/map, load this mod as a dependency!

Es dürfen an diesem Script keine Veränderungen ohne Erlaubnis von Braeven gemacht werden.
Nicht das Script in mods/maps kopieren, ladet den Mod über eine Dependency!
]]





FAMerchStore = {}

PlayerStyle.FAMerchStore = {}
PlayerStyle.FAMerchStore.maxUV = 300
PlayerStyle.FAMerchStore.diffuses = {}
PlayerStyle.FAMerchStore.masks = {}
PlayerStyle.FAMerchStore.icons = {}
PlayerStyle.FAMerchStore.modName = {}
PlayerStyle.FAMerchStore.type = {}
PlayerStyle.FAMerchStore.colorable = {}
PlayerStyle.FAMerchStore.invisible = {}
PlayerStyle.FAMerchStore.colorsPrimary = {}
PlayerStyle.FAMerchStore.colorsSecondary = {}
PlayerStyle.FAMerchStore.defaultPrimary = {}
PlayerStyle.FAMerchStore.filenameMale = {}
PlayerStyle.FAMerchStore.filenameFemale = {}
PlayerStyle.FAMerchStore.iconOffset = {}
PlayerStyle.FAMerchStore.beltHidden = {}
PlayerStyle.FAMerchStore.hidesBodypart = {}
PlayerStyle.FAMerchStore.extent = {}
PlayerStyle.FAMerchStore.belt = {}
PlayerStyle.FAMerchStore.lowHigh = {}
PlayerStyle.FAMerchStore.supportedClothing = {
--Headgear
VINTAGE = true,
MILITIA = true,
BEANIE = true,
BALLCAP = true,
COWBOY = true,
OUTBACK = true,
FISHER = true,
--Tops
HOODIE = true,
SWEATER = true,
POLOSHIRT = true,
TSHIRTF = true,
TSHIRTFEMALE = true,
TSHIRTM = true,
TSHIRTMALE = true,
AVIATOR = true,
WARNINGVEST = true,
WORKJACKET = true,
WINDBREAKER = true,
MOTIONJACKET = true,
MOTION2020JACKET = true,
CONCRETEJACKET = true,
SLIMCOAT = true,
DENIMJACKET = true,
LEATHERJACKET = true,
PLAIDSHIRTMALE = true,
PLAIDSHIRTFEMALE = true,
VEST = true,
PUFFJACKET = true,
PUFFYJACKETFEMALE = true,
DECKJACKETMALE = true,
WOOLCOATFEMALE = true,
--Pants
MOTIONPANTS = true,
MOTION2020PANTS = true,
CONCRETEPANTS = true,
LEATHERPANTS = true,
EQUESTRIANPANTS = true,
CHINOS = true,
CARGOPANTS = true,
JEANS = true
}



--XML Schema erstellen
function FAMerchStore:AddXmlSchema()
	FAMerchStore.XmlSchema = XMLSchema.new("FAMerchStore")
	local schema = FAMerchStore.XmlSchema
	schema:register(XMLValueType.STRING, "modDesc.clothes.item(?)", "FA Merch Store Script", nil, false)
	schema:register(XMLValueType.STRING, "modDesc.clothes.item(?)#diffuse", "FA Merch Store: Path to the diffuse-file", nil, false)
	schema:register(XMLValueType.STRING, "modDesc.clothes.item(?)#invisible", "FA Merch Store: Path to the diffuse-file", nil, false)
	schema:register(XMLValueType.STRING, "modDesc.clothes.item(?)#mask", "FA Merch Store: Path to the mask-file", nil, false)
	schema:register(XMLValueType.STRING, "modDesc.clothes.item(?)#type", "FA Merch Store: Clothing-Type", nil, false)
	schema:register(XMLValueType.STRING, "modDesc.clothes.item(?)#icon", "FA Merch Store: Icon for the clothing", nil, false)
	schema:register(XMLValueType.STRING, "modDesc.clothes.item(?)#colorable", "FA Merch Store: Can the item be colored differently", nil, true)
	schema:register(XMLValueType.STRING, "modDesc.clothes.item(?).colors.color()#primary", "FA Merch Store: Color-Option primary", nil, false)
	schema:register(XMLValueType.STRING, "modDesc.clothes.item(?).colors.color()#secondary", "FA Merch Store: Color-Option secondry", nil, false)
end

FAMerchStore:AddXmlSchema()



--Neue Kleidung in Tabellen hinterlegen
function PlayerStyle.FAMerchStore:loadClothes(modDir, modName)
	local xmlFile = XMLFile.load("FAMerchStore", modDir.."modDesc.xml", FAMerchStore.XmlSchema)

	if xmlFile ~= nil and xmlFile ~= 0 then
		print("Wardrobe Plus: Loading Clothes for " .. modName)
		local before = {}

		xmlFile:iterate("modDesc.clothes.item", function (_, clothesKey)
			local clothesType = string.upper(xmlFile:getValue(clothesKey .. "#type"))
			local mask = xmlFile:getString(clothesKey .. "#mask")
			local diffuse = xmlFile:getString(clothesKey .. "#diffuse")
			local icon = xmlFile:getString(clothesKey .. "#icon")

			if PlayerStyle.FAMerchStore.supportedClothing[clothesType] ~= nil then
				mask = Utils.getFilename(mask, modDir)
				diffuse = Utils.getFilename(diffuse, modDir)
				icon = Utils.getFilename(icon, modDir)
				if not fileExists(mask) then
					Logging.error("Error Wardrobe Plus: ".. modName .." - mask("..mask..") not found for : '" .. clothesType .. "', skipped adding.")
				elseif not fileExists(diffuse) then
					Logging.error("Error Wardrobe Plus: ".. modName .." - diffuse("..diffuse..") not found for : '" .. clothesType .. "', skipped adding.")
				elseif not fileExists(icon) then
					Logging.error("Error Wardrobe Plus: ".. modName .." - icon("..icon..") not found for : '" .. clothesType .. "', skipped adding.")
				else
					local colorable = string.upper(xmlFile:getString(clothesKey .. "#colorable", "NIL"))
					local invisible = xmlFile:getBool(clothesKey .. "#invisible", false)
					local maxUV = PlayerStyle.FAMerchStore.maxUV + 1
					PlayerStyle.FAMerchStore.masks[maxUV] = mask
					PlayerStyle.FAMerchStore.diffuses[maxUV] = diffuse
					PlayerStyle.FAMerchStore.icons[maxUV] = icon
					PlayerStyle.FAMerchStore.colorsPrimary[maxUV] = {}
					PlayerStyle.FAMerchStore.colorsSecondary[maxUV] = {}
					PlayerStyle.FAMerchStore.hidesBodypart[maxUV] = {}
					PlayerStyle.FAMerchStore.extent[maxUV] = {}
					
					--a bunch of things that rarely change
					PlayerStyle.FAMerchStore.beltHidden[maxUV] = "true"
					PlayerStyle.FAMerchStore.belt[maxUV] = "0"
					PlayerStyle.FAMerchStore.lowHigh[maxUV] = "low"
					PlayerStyle.FAMerchStore.colorable[maxUV] = "1"
					PlayerStyle.FAMerchStore.invisible[maxUV] = invisible

					if clothesType == "BALLCAP" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.0183 0.0183 0.0183 1"
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/attachments/headgearBallcap.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/attachments/headgearBallcap.i3d"
						PlayerStyle.FAMerchStore.iconOffset[maxUV] = "0 0 -.275"
						PlayerStyle.FAMerchStore.type[maxUV] = "headgear"
					elseif clothesType == "BEANIE" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.0000 0.1845 0.2918 1"
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/attachments/headgearBeanie.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/attachments/headgearBeanie.i3d"
						PlayerStyle.FAMerchStore.iconOffset[maxUV] = "0 .04 -.1"
						PlayerStyle.FAMerchStore.type[maxUV] = "headgear"
					elseif clothesType == "MILITIA" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.045 0.055 0.085 1"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.3 0.25 0.19 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.21 0.17 0.12 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.08 0.078 0.05 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.045 0.055 0.085 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.035 0.04 0.045 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.02 0.02 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/attachments/headgearMilitia.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/attachments/headgearMilitia.i3d"
						PlayerStyle.FAMerchStore.iconOffset[maxUV] = "0 0 -.25"
						PlayerStyle.FAMerchStore.type[maxUV] = "headgear"
					elseif clothesType == "VINTAGE" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.075 0.08 0.12 1"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.11 0.13 0.16 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.16 0.13 0.11 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1 0.1 0.1 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.12 0.08 0.075 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.075 0.08 0.12 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.05 0.05 0.05 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/attachments/headgearVintage.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/attachments/headgearVintage.i3d"
						PlayerStyle.FAMerchStore.iconOffset[maxUV] = "0 0 -.2"
						PlayerStyle.FAMerchStore.type[maxUV] = "headgear"
					elseif clothesType == "COWBOY" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.24 0.15 0.09 1"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.95 0.85 0.75 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.6 0.545 0.5 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.45 0.4 0.295 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.315 0.24 0.15 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.24 0.15 0.09 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.15 0.1 0.08 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.09 0.085 0.08 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.09 0.0585 0.036 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.04 0.035 0.035 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/attachments/headgearCowboy.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/attachments/headgearCowboy.i3d"
						PlayerStyle.FAMerchStore.iconOffset[maxUV] = "0 -.025 -.325"
						PlayerStyle.FAMerchStore.type[maxUV] = "headgear"
					elseif clothesType == "FISHER" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.5089 0.4072 0.3050 1"
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/attachments/headgearFisherman.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/attachments/headgearFisherman.i3d"
						PlayerStyle.FAMerchStore.iconOffset[maxUV] = "0 0 -.2"
						PlayerStyle.FAMerchStore.type[maxUV] = "headgear"
					elseif clothesType == "OUTBACK" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.15 0.1 0.08 1"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.315 0.24 0.15 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.24 0.15 0.09 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.15 0.1 0.08 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.09 0.085 0.08 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.09 0.0585 0.036 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.04 0.035 0.035 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/attachments/headgearOutback.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player01/attachments/headgearOutback.i3d"
						PlayerStyle.FAMerchStore.iconOffset[maxUV] = "0 0 -.275"
						PlayerStyle.FAMerchStore.type[maxUV] = "headgear"
					elseif clothesType == "SWEATER" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.0000 0.1845 0.2918 1"
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topLightSweater.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topLightSweater.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "HOODIE" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.2051 0.2051 0.2051 1"
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topHoodie.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topHoodie.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "POLOSHIRT" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.1683 0.1248 0.0999 1"
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topCollaredShirt.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topCollaredShirt.i3d"
						PlayerStyle.FAMerchStore.beltHidden[maxUV] = "false"
						PlayerStyle.FAMerchStore.type[maxUV] = "top2"
					elseif clothesType == "TSHIRTF" or clothesType == "TSHIRTFEMALE" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.3324 0.3324 0.3324 1"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topTeeShirt.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top2"
					elseif clothesType == "TSHIRTM"or clothesType == "TSHIRTMALE" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.3324 0.3324 0.3324 1"
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topTeeShirt.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top2"
					elseif clothesType == "AVIATOR" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.09 0.085 0.08 0.7"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.155 0.14 0.14 0.25")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.12 0.1 0.095 0.4")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1 0.095 0.111 0.55")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.09 0.085 0.08 0.7")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.08 0.0555 0.04 0.85")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.04 0.035 0.035 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topAviatorJacket.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topAviatorJacket.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top3"
					elseif clothesType == "WINDBREAKER" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.0071 0.0003 0.0673 1"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.5089 0.4755 0.0097 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.4621 0.1569 0.0121 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.4341 0.0630 0.0097 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1879 0.0252 0.0008 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1860 0.0004 0.0010 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1683 0.0000 0.0452 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1683 0.0000 0.1274 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0782 0.0000 0.1620 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0330 0.0003 0.0642 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0003 0.2384 0.4678 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0003 0.0865 0.2789 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0188 0.0029 0.1590 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0071 0.0003 0.0673 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1329 0.3278 0.0319 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0513 0.1366 0.0108 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0006 0.2346 0.0545 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0007 0.1036 0.0189 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0383 0.0285 0.0253 1")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0116 0.0116 0.0116 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topWindBreaker.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topWindBreaker.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "WORKJACKET" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.900 0.100 0.000 1.000"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.900 0.100 0.000 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.060 0.080 0.150 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.000 0.600 0.000 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.060 0.080 0.150 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.700 0.600 0.000 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.060 0.080 0.150 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.000 0.600 0.400 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.540 0.540 0.000 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.920 0.000 0.000 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.800 0.800 0.800 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.920 0.000 0.000 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.820 0.520 0.000 1.000")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topWorkJacket.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player01/clothes/tops/topWorkJacket.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "WARNINGVEST" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.3324 0.3324 0.3324 1"
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topConstruction.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topConstruction.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top2"
					elseif clothesType == "CONCRETEJACKET" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.150 0.140 0.110 0.600"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.150 0.140 0.110 0.600")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.270 0.260 0.220 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.060 0.120 0.330 0.800")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.070 0.080 0.150 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.104 0.105 0.120 0.800")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.762 0.768 0.782 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.030 0.035 0.040 0.800")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.030 0.035 0.040 1.000")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/brands/brand08/engelbertStraussConcreteJacket.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/brands/brand08/engelbertStraussConcreteJacket.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "MOTION2020JACKET" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.019 0.070 0.045 1.000"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.150 0.140 0.110 0.600")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.270 0.260 0.220 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.912 0.914 0.952 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.000 0.080 0.260 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.403 0.412 0.461 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.030 0.064 0.135 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.104 0.105 0.120 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.762 0.768 0.782 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.191 0.167 0.155 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.505 0.493 0.511 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.107 0.074 0.061 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.070 0.560 0.060 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.510 0.040 0.050 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.330 0.630 0.040 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.019 0.070 0.045 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.070 0.560 0.060 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.026 0.140 0.291 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.008 0.013 0.037 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.050 0.096 0.218 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.510 0.040 0.050 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.045 0.053 0.102 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.000 0.240 0.700 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.030 0.035 0.040 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.762 0.768 0.782 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.030 0.035 0.040 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.330 0.630 0.040 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.032 0.038 0.049 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.000 0.240 0.700 1.000")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/brands/brand08/engelbertStraussMotion2020Jacket.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/brands/brand08/engelbertStraussMotion2020Jacket.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "SLIMCOAT" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.420 0.430 0.400 1.000"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.420 0.430 0.400 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.550 0.470 0.440 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.800 0.650 0.540 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.700 0.520 0.370 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.470 0.330 0.240 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.540 0.440 0.420 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.420 0.240 0.090 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.630 0.450 0.370 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.240 0.070 0.000 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.490 0.440 0.380 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.090 0.060 0.030 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.460 0.440 0.380 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.060 0.080 0.020 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.390 0.440 0.380 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.160 0.180 0.240 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.490 0.400 0.380 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.030 0.070 0.100 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.440 0.470 0.470 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.020 0.020 0.040 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.460 0.440 0.380 1.000")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topSlimCoat.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player01/clothes/tops/topSlimCoat.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "DENIMJACKET" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.04 0.1 0.2 1"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.19 0.26 0.33 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.08 0.2 0.3 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.04 0.1 0.2 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.06 0.06 0.085 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.035 0.085 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.025 0.03 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topDenimJacket.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topDenimJacket.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "PLAIDSHIRTMALE" or clothesType == "PLAIDSHIRTFEMALE" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.0809 0.0624 0.0534 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.4179 0.0003 0.0125 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.4341 0.0630 0.0097 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.4621 0.1569 0.0121 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0513 0.1366 0.0108 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0007 0.1036 0.0189 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0003 0.0865 0.2789 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0006 0.1062 0.2159 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0071 0.0003 0.0673 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0330 0.0003 0.0642 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0782 0.0000 0.1620 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1683 0.0000 0.1274 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1683 0.0000 0.0452 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1860 0.0004 0.0010 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1879 0.0252 0.0008 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0383 0.0285 0.0253 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0809 0.0624 0.0534 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1651 0.1248 0.1022 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.3155 0.2371 0.1867 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.3690 0.2090 0.0872 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.2502 0.1248 0.0472 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1697 0.0723 0.0197 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1161 0.0395 0.0079 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0768 0.0222 0.0043 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0365 0.0110 0.0034 1")
						if clothesType == "PLAIDSHIRTMALE" then
							PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topPlaidShirt01.i3d"
						else
							PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topPlaidShirt01.i3d"
						end
						PlayerStyle.FAMerchStore.type[maxUV] = "top4"
					elseif clothesType == "LEATHERJACKET" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.24 0.15 0.09 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.315 0.24 0.15 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.24 0.15 0.09 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.15 0.1 0.08 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.09 0.085 0.08 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.09 0.0585 0.036 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.04 0.035 0.035 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topLeatherJacket.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topLeatherJacket.i3d"
						PlayerStyle.FAMerchStore.beltHidden[maxUV] = "false"
						PlayerStyle.FAMerchStore.type[maxUV] = "top4"
					elseif clothesType == "VEST" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.1697 0.0723 0.0197 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.3690 0.2090 0.0872 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.2502 0.1248 0.0472 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1697 0.0723 0.0197 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.1161 0.0395 0.0079 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0768 0.0222 0.0043 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.0365 0.0110 0.0034 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topVest.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topVest.i3d"
						PlayerStyle.FAMerchStore.beltHidden[maxUV] = "false"
						PlayerStyle.FAMerchStore.type[maxUV] = "top4"
					elseif clothesType == "PUFFJACKET" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.970 0.450 0.090 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.920 0.920 0.820 0.85")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "1.000 0.310 0.090 0.84")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.830 0.730 0.570 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.530 0.600 0.770 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.700 0.700 0.800 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.080 0.080 0.110 0.84")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.970 0.450 0.090 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.100 0.100 0.150 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.870 0.100 0.120 0.96")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.080 0.080 0.110 0.93")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.580 0.100 0.210 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.840 0.840 1.000 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.520 0.260 0.850 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.080 0.100 0.210 0.84")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.370 0.130 0.390 0.8")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.070 0.360 0.370 0.92")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.070 0.220 0.220 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.560 0.310 0.090 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.160 0.220 0.330 0.9")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.100 0.120 0.180 0.9")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.021 0.020 0.022 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.021 0.020 0.022 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topPuffJacket.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player01/clothes/tops/topPuffJacket.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "PUFFYJACKETFEMALE" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.0408 0.0408 0.0408 1"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topPuffyJacket.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "DECKJACKETMALE" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.240 0.150 0.090 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "1.000 1.000 1.000 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.315 0.240 0.150 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.240 0.150 0.090 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.369 0.209 0.087 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.250 0.124 0.047 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.169 0.072 0.019 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.116 0.039 0.007 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.076 0.022 0.004 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.036 0.011 0.003 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.190 0.260 0.330 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.080 0.200 0.300 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.040 0.100 0.200 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.060 0.060 0.085 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.035 0.085 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.150 0.100 0.080 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.090 0.058 0.036 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.090 0.085 0.080 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.040 0.035 0.035 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.025 0.030 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/tops/topDeckJacket.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "WOOLCOATFEMALE" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.240 0.150 0.090 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "1.000 1.000 1.000 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.315 0.240 0.150 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.240 0.150 0.090 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.369 0.209 0.087 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.250 0.124 0.047 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.169 0.072 0.019 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.116 0.039 0.007 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.076 0.022 0.004 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.036 0.011 0.003 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.190 0.260 0.330 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.080 0.200 0.300 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.040 0.100 0.200 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.060 0.060 0.085 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.035 0.085 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.150 0.100 0.080 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.090 0.058 0.036 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.090 0.085 0.080 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.040 0.035 0.035 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.025 0.030 1")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.090 0.085 0.080 1")
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/tops/topWoolCoat.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "MOTIONJACKET" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.377 0.305 0.254 0.780"
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.779 0.810 0.921 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.095 0.104 0.132 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.480 0.480 0.480 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.220 0.190 0.170 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.377 0.305 0.254 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.262 0.183 0.157 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.201 0.146 0.116 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.079 0.052 0.038 0.680")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.129 0.140 0.170 0.880")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.038 0.037 0.044 0.880")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.120 0.127 0.140 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.195 0.218 0.248 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.035 0.040 0.050 0.680")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.035 0.040 0.050 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.290 0.271 0.179 0.680")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.120 0.117 0.078 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.040 0.170 0.090 0.680")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.030 0.040 0.050 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.089 0.151 0.321 0.600")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.048 0.067 0.114 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.043 0.130 0.418 0.600")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.035 0.040 0.050 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.060 0.070 0.150 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.040 0.040 0.040 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.510 0.040 0.050 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.035 0.040 0.050 0.780")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/brands/brand08/engelbertStraussMotionJacket.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/brands/brand08/engelbertStraussMotionJacket.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif clothesType == "JEANS" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.08 0.2 0.3 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.69 0.82 0.9 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.45 0.6 0.8 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.3 0.45 0.7 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.19 0.26 0.33 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.08 0.2 0.3 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.04 0.1 0.2 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.06 0.06 0.085 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.035 0.085 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.025 0.03 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/bottoms/botJeans.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/bottoms/botJeans.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom"
					elseif clothesType == "CARGOPANTS" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.08 0.078 0.05 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.65 0.54 0.52 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.52 0.42 0.33 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.46 0.32 0.2 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.3 0.25 0.19 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.21 0.17 0.12 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.08 0.078 0.05 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.045 0.055 0.085 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.035 0.04 0.045 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.02 0.02 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/bottoms/botCargo.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/bottoms/botCargo.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom"
					elseif clothesType == "CHINOS" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.3 0.25 0.19 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.65 0.54 0.52 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.52 0.42 0.33 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.46 0.32 0.2 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.3 0.25 0.19 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.21 0.17 0.12 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.08 0.078 0.05 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.045 0.055 0.085 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.035 0.04 0.045 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.025 0.02 0.02 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/bottoms/botChinos.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/bottoms/botChinos.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom"
					elseif clothesType == "EQUESTRIANPANTS" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.065 0.065 0.066 1"
						PlayerStyle.FAMerchStore.lowHigh[maxUV] = "high"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.12 0.19 0.22 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.147 0.091 0.074 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.065 0.065 0.066 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.04 0.05 0.072 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.07 0.042 0.025 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.03 0.03 0.035 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/bottoms/botEquestrian.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/bottoms/botEquestrian.i3d"
						PlayerStyle.FAMerchStore.belt[maxUV] = nil
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom2"
					elseif clothesType == "LEATHERPANTS" then
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.24 0.15 0.09 1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.315 0.24 0.15 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.24 0.15 0.09 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.15 0.1 0.08 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.09 0.085 0.08 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.09 0.0585 0.036 1")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.04 0.035 0.035 1")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/clothes/bottoms/botLeather.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/clothes/bottoms/botLeather.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom"
					elseif clothesType == "CONCRETEPANTS" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.150 0.140 0.110 0.600"
						PlayerStyle.FAMerchStore.belt[maxUV] = "1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.150 0.140 0.110 0.600")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.270 0.260 0.220 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.060 0.120 0.330 0.800")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.070 0.080 0.150 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.104 0.105 0.120 0.800")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.762 0.768 0.782 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.030 0.035 0.040 0.800")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.030 0.035 0.040 1.000")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/brands/brand08/engelbertStraussConcretePants.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/brands/brand08/engelbertStraussConcretePants.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom3"
					elseif clothesType == "MOTION2020PANTS" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.019 0.070 0.045 1.000"
						PlayerStyle.FAMerchStore.belt[maxUV] = "1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.912 0.914 0.952 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.000 0.080 0.260 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.403 0.412 0.461 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.030 0.064 0.135 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.104 0.105 0.120 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.762 0.768 0.782 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.191 0.167 0.155 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.505 0.493 0.511 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.107 0.074 0.061 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.070 0.560 0.060 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.510 0.040 0.050 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.330 0.630 0.040 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.019 0.070 0.045 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.070 0.560 0.060 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.026 0.140 0.291 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.008 0.013 0.037 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.050 0.096 0.218 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.510 0.040 0.050 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.045 0.053 0.102 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.000 0.240 0.700 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.030 0.035 0.040 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.762 0.768 0.782 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.030 0.035 0.040 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.330 0.630 0.040 1.000")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.032 0.038 0.049 1.000")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.000 0.240 0.700 1.000")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/brands/brand08/engelbertStraussMotion2020Pants.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/brands/brand08/engelbertStraussMotion2020Pants.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom3"
					elseif clothesType == "MOTIONPANTS" then
						PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
						PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = "0.377 0.305 0.254 0.780"
						PlayerStyle.FAMerchStore.belt[maxUV] = "1"
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.779 0.810 0.921 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.095 0.104 0.132 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.480 0.480 0.480 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.220 0.190 0.170 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.377 0.305 0.254 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.262 0.183 0.157 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.201 0.146 0.116 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.079 0.052 0.038 0.680")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.129 0.140 0.170 0.880")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.038 0.037 0.044 0.880")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.120 0.127 0.140 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.195 0.218 0.248 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.035 0.040 0.050 0.680")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.035 0.040 0.050 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.290 0.271 0.179 0.680")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.120 0.117 0.078 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.040 0.170 0.090 0.680")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.030 0.040 0.050 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.089 0.151 0.321 0.600")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.048 0.067 0.114 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.043 0.130 0.418 0.600")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.035 0.040 0.050 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.060 0.070 0.150 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.040 0.040 0.040 0.780")
            table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], "0.510 0.040 0.050 0.780")
						table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], "0.035 0.040 0.050 0.780")
						PlayerStyle.FAMerchStore.filenameMale[maxUV] = "dataS/character/player01/brands/brand08/engelbertStraussMotionPants.i3d"
						PlayerStyle.FAMerchStore.filenameFemale[maxUV] = "dataS/character/player02/brands/brand08/engelbertStraussMotionPants.i3d"
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom3"
					end

					if PlayerStyle.FAMerchStore.type[maxUV] == "top" then
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "upperChest")
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "armsUpper")
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "armsLower")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "1 hands")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "2 over")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "3 under")
					elseif PlayerStyle.FAMerchStore.type[maxUV] == "top3" then
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "upperChest")
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "armsUpper")
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "armsLower")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "2 hands")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "3 over")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "4 under")
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif PlayerStyle.FAMerchStore.type[maxUV] == "top4" then
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "armsUpper")
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "armsLower")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "1 hands")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "2 over")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "3 under")
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					elseif PlayerStyle.FAMerchStore.type[maxUV] == "bottom2" then
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "legs")
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom"
					elseif PlayerStyle.FAMerchStore.type[maxUV] == "bottom3" then
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "legs")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "3 low")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "3 low2")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "4 cowboy")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "2 high")
						PlayerStyle.FAMerchStore.type[maxUV] = "bottom"
					elseif PlayerStyle.FAMerchStore.type[maxUV] == "bottom" then
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "legs")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "2 low")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "2 low2")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "4 cowboy")
						table.insert(PlayerStyle.FAMerchStore.extent[maxUV], "1 high")
					elseif PlayerStyle.FAMerchStore.type[maxUV] == "top2" then
						table.insert(PlayerStyle.FAMerchStore.hidesBodypart[maxUV], "upperChest")
						PlayerStyle.FAMerchStore.type[maxUV] = "top"
					end
					if string.upper(colorable) ~= "NIL" then
						if tonumber(colorable) == 0 then
							PlayerStyle.FAMerchStore.colorable[maxUV] = "0"
							PlayerStyle.FAMerchStore.colorsPrimary[maxUV] = {}
							PlayerStyle.FAMerchStore.colorsSecondary[maxUV] = {}
						elseif tonumber(colorable) >= 1 or string.upper(colorable) == "TRUE" then
							PlayerStyle.FAMerchStore.colorable[maxUV] = "1"
							if xmlFile:hasProperty(clothesKey .. ".colors") then
								PlayerStyle.FAMerchStore.colorsPrimary[maxUV] = {}
								PlayerStyle.FAMerchStore.colorsSecondary[maxUV] = {}
								xmlFile:iterate(clothesKey .. ".colors.color", function (index, colorKey)
									local primary = xmlFile:getString(colorKey .. "#primary")
									local secondary = xmlFile:getString(colorKey .. "#secondary")
									local testprimary = g_brandColorManager:getBrandColorByName(primary)
									local testsecondary = g_brandColorManager:getBrandColorByName(secondary)
									if testprimary ~= nil then
										primary = testprimary[1] .." ".. testprimary[2] .." ".. testprimary[3] .." ".. testprimary[4]
									end
									if secondary ~= nil then
										if testsecondary ~= nil then
											secondary = testsecondary[1] .." ".. testsecondary[2] .." ".. testsecondary[3] .." ".. testsecondary[4]
										end
										table.insert(PlayerStyle.FAMerchStore.colorsSecondary[maxUV], secondary)
									end
									table.insert(PlayerStyle.FAMerchStore.colorsPrimary[maxUV], primary)
								end)
								if #PlayerStyle.FAMerchStore.colorsSecondary[maxUV] > 0 then
									PlayerStyle.FAMerchStore.colorable[maxUV] = "2"
								end
								if #PlayerStyle.FAMerchStore.colorsPrimary[maxUV] > 0 then
									local prim = PlayerStyle.FAMerchStore.colorsPrimary[maxUV]
									PlayerStyle.FAMerchStore.defaultPrimary[maxUV] = prim[1]
								end
							else
								--Ingame Farbwahl anwenden, Voreingetrage Farben löschen
								PlayerStyle.FAMerchStore.colorsPrimary[maxUV] = {}
							end
						end
					end
					if before[clothesType] == nil then
						PlayerStyle.FAMerchStore.modName[maxUV] = modName .."_0_".. clothesType
						before[clothesType] = 1
					else
						PlayerStyle.FAMerchStore.modName[maxUV] = modName .."_".. before[clothesType] .."_".. clothesType
						before[clothesType] = before[clothesType] + 1
					end
					PlayerStyle.FAMerchStore.maxUV = maxUV
				end
			else
				Logging.error("Error Wardrobe Plus: ".. modName .." - Invalid Clothing-Type: '" .. clothesType .. "', skipped adding.")
			end
		end)
	end

	xmlFile:delete()
end



--Überschrieben um Texturen austauschen zu können
function FAMerchStore:apply(superFunc, skeleton, mesh, hideBody, models)
	self:loadConfigurationIfRequired()

	if #self.faceConfig.items == 0 then
		return
	end

	local function indexToObject(index)
		if index == nil then
			return nil
		end

		if index.isSkeleton then
			return I3DUtil.indexToObject(skeleton, index.path)
		else
			return I3DUtil.indexToObject(mesh, index.path)
		end
	end

	local function getNodeClone(filename)
		if models[filename] == nil then
			return nil
		end

		local cloneId = clone(models[filename], false, false, false)

		return cloneId
	end

	for _, nodeIndex in pairs(self.attachPoints) do
		local node = indexToObject(nodeIndex)

		for i = getNumOfChildren(node) - 1, 0, -1 do
			delete(getChildAt(node, i))
		end
	end

	self.invisible = false
	setVisibility(mesh, true)
	if self.topConfig.selection ~= 0 then
		local top = self.topConfig.items[self.topConfig.selection]
		if PlayerStyle.FAMerchStore.invisible[top.uvSlot] ~= nil and PlayerStyle.FAMerchStore.invisible[top.uvSlot] == true then
			setVisibility(mesh, false)
			self.invisible = true
		end
	end

	if self.faceConfig.selection ~= 0 then
		local skinColorR, skinColorG, skinColorB = unpack(self.faceConfig.items[self.faceConfig.selection].skinColor)

		for _, part in ipairs(self.bodyParts) do
			local node = indexToObject(part.index)

			setVisibility(node, not hideBody)
			setShaderParameter(node, "colorScaleR", skinColorR, skinColorG, skinColorB, 1, false)
		end

		local selectedFace = self.faceConfig.items[math.max(self.faceConfig.selection, 1)]
		local modelNode = getNodeClone(selectedFace.filename)

		if modelNode == nil then
			print_r(models)
			printCallstack()

			return
		end

		local faceSourceNode = I3DUtil.indexToObject(modelNode, selectedFace.index)
		local oldFaceSkeleton = getChildAt(modelNode, 0)

		link(indexToObject(selectedFace.attachNode), faceSourceNode)

		for i = 0, getNumOfChildren(faceSourceNode) - 1 do
			local node = getChildAt(faceSourceNode, i)

			setShapeBones(node, skeleton, oldFaceSkeleton, true)

			if getHasShaderParameter(node, "sssColor") then
				setShaderParameter(node, "colorScaleR", skinColorR, skinColorG, skinColorB, 1, false)
			end
		end

		delete(modelNode)
	end

	local function enable(item, extentToCompare, extentToCompare2)
		if item == nil then
			return nil
		end

		local modelNode = getNodeClone(item.filename)

		if modelNode == nil then
			return nil
		end

		local node = I3DUtil.indexToObject(modelNode, item.index)
		local attachNode = indexToObject(item.attachNode)

		link(attachNode, node)

		local node2 = nil

		if item.index2 ~= nil then
			node2 = I3DUtil.indexToObject(modelNode, item.index2)

			link(attachNode, node2)
		end

		if not item.attachNode.isSkeleton then
			local oldSkeleton = getChildAt(modelNode, 0)

			I3DUtil.setShapeBonesRec(node, skeleton, oldSkeleton, true)

			if node2 ~= nil then
				I3DUtil.setShapeBonesRec(node2, skeleton, oldSkeleton, true)
			end
		end

		for _, partIndex in ipairs(item.hiddenBodyParts) do
			local partNode = indexToObject(self.bodyParts[partIndex].index)

			setVisibility(partNode, false)
		end

		if extentToCompare ~= nil and item.extents ~= nil then
			if item.extents[extentToCompare] == nil then
				extentToCompare = "hands"
			end

			local extentsSeen = {}

			for typ, nodeIndex in pairs(item.extents) do
				local show = false

				if typ == extentToCompare or typ == extentToCompare2 then
					show = true
				end

				local extentNode = I3DUtil.indexToObject(node, nodeIndex)

				if extentsSeen[extentNode] == nil then
					setVisibility(extentNode, show)

					if show then
						extentsSeen[extentNode] = true
					end
				end
			end
		end

		if item.transforms ~= nil then
			local transform = item.transforms[self.faceConfig.selection]

			setTranslation(node, unpack(transform.translation))
			setRotation(node, math.rad(transform.rotation[1]), math.rad(transform.rotation[2]), math.rad(transform.rotation[3]))
			setScale(node, unpack(transform.scale))
		end

		delete(modelNode)

		return node, node2
	end

	local function updateColors(node, item, selectedColorIndex)
		if node == nil then
			return
		end

		local numColors = item.numColors

		if numColors == 0 then
			return
		end

		if selectedColorIndex == nil then
			printCallstack()

			return
		end

		local color = item.colors[selectedColorIndex]

		if color ~= nil and numColors >= 1 then
			local primaryColor = color.primary

			I3DUtil.setShaderParameterRec(node, "colorScaleR", primaryColor[1], primaryColor[2], primaryColor[3], primaryColor[4], false)
		end

		if color ~= nil and numColors >= 2 then
			local secondaryColor = color.secondary

			if secondaryColor ~= nil then
				I3DUtil.setShaderParameterRec(node, "colorScaleG", secondaryColor[1], secondaryColor[2], secondaryColor[3], secondaryColor[4], false)
			end
		end
	end

	local function updateHairColors(node, item)
		if item == nil or node == nil then
			return
		end

		local selectedColorItem = item.colors[self.hairStyleConfig.color]
		local hairColorR, hairColorG, hairColorB = unpack(selectedColorItem.primary)
		local hairColorR2, hairColorG2, hairColorB2 = unpack(selectedColorItem.secondary)

		I3DUtil.setShaderParameterRec(node, "colorScaleG", hairColorR, hairColorG, hairColorB, 1, false)
		I3DUtil.setShaderParameterRec(node, "colorScaleR", hairColorR2, hairColorG2, hairColorB2, 1, false)
	end

	if self.topConfig.selection ~= 0 then
		local itemAttachNode = enable(self.topConfig.items[self.topConfig.selection], self.glovesConfig.selection ~= 0 and self.glovesConfig.items[self.glovesConfig.selection].extent or "hands")
		local top = self.topConfig.items[self.topConfig.selection]
		if top.uvSlot > 300 then
			local overwrite = ""
			local sleeves1 = ""
			local sleeves2 = ""
			local sleeves3 = ""
			local hat = ""
			if top.filename == "dataS/character/player02/clothes/tops/topLightSweater.i3d" or top.filename == "dataS/character/player01/clothes/tops/topLightSweater.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "lightSweater")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleevesHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleevesOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleevesUnderGlove")
			elseif top.filename == "dataS/character/player02/clothes/tops/topHoodie.i3d" or top.filename == "dataS/character/player01/clothes/tops/topHoodie.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "Hoodie")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player02/clothes/tops/topAviatorJacket.i3d" or top.filename == "dataS/character/player01/clothes/tops/topAviatorJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "aviatorJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleevesHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player01/clothes/tops/topWorkJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "workJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
				hat = I3DUtil.getChildByName(itemAttachNode, "workJacketHat")
			elseif top.filename == "dataS/character/player02/clothes/tops/topWindBreaker.i3d" or top.filename == "dataS/character/player01/clothes/tops/topWindBreaker.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "windBreaker")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleevesHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleevesOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleevesUnderGlove")
			elseif top.filename == "dataS/character/player01/clothes/tops/topSlimCoat.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "slimCoat")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player02/brands/brand08/engelbertStraussMotionJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "motionJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleevesHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player01/brands/brand08/engelbertStraussMotionJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "MotionJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player02/brands/brand08/engelbertStraussMotion2020Jacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "motion2020Jacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleevesHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player01/brands/brand08/engelbertStraussMotion2020Jacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "Motion2020Jacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player02/brands/brand08/engelbertStraussConcreteJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "concreteJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleevesHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player01/brands/brand08/engelbertStraussConcreteJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "ConcreteJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player01/clothes/tops/topDeckJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "deckJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player02/clothes/tops/topWoolCoat.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "woolCoat")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")			
			elseif top.filename == "dataS/character/player02/clothes/tops/topVest.i3d" or top.filename == "dataS/character/player01/clothes/tops/topVest.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "vest")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleevesHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleevesOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleevesUnderGlove")
			elseif top.filename == "dataS/character/player02/clothes/tops/topDenimJacket.i3d" or top.filename == "dataS/character/player01/clothes/tops/topDenimJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "denimJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player02/clothes/tops/topLeatherJacket.i3d" or top.filename == "dataS/character/player01/clothes/tops/topLeatherJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "leatherJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player02/clothes/tops/topPlaidShirt01.i3d" or top.filename == "dataS/character/player01/clothes/tops/topPlaidShirt01.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "plaidShirt01")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleevesHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleevesOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleevesUnderGlove")
			elseif top.filename == "dataS/character/player02/clothes/tops/topPuffyJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "puffyJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player01/clothes/tops/topPuffJacket.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "puffJacket")
				sleeves1 = I3DUtil.getChildByName(itemAttachNode, "sleeveHands")
				sleeves2 = I3DUtil.getChildByName(itemAttachNode, "sleeveOverGlove")
				sleeves3 = I3DUtil.getChildByName(itemAttachNode, "sleeveUnderGlove")
			elseif top.filename == "dataS/character/player02/clothes/tops/topConstruction.i3d" or top.filename == "dataS/character/player01/clothes/tops/topConstruction.i3d" then
				overwrite = I3DUtil.getChildByName(itemAttachNode, "vest")
			else
				local materialId = getMaterial(itemAttachNode, 0)
				materialId = setMaterialDiffuseMapFromFile(materialId, PlayerStyle.FAMerchStore.diffuses[top.uvSlot], true, true, false)
				materialId = setMaterialCustomMapFromFile(materialId, "mMaskMap", PlayerStyle.FAMerchStore.masks[top.uvSlot], true, true, false)
				setMaterial(itemAttachNode, materialId, 0)
				updateColors(itemAttachNode, self.topConfig.items[self.topConfig.selection], self.topConfig.color)
			end

			if overwrite ~= "" then
				local materialId = getMaterial(overwrite, 0)
				materialId = setMaterialDiffuseMapFromFile(materialId, PlayerStyle.FAMerchStore.diffuses[top.uvSlot], true, true, false)
				materialId = setMaterialCustomMapFromFile(materialId, "mMaskMap", PlayerStyle.FAMerchStore.masks[top.uvSlot], true, true, false)
				setMaterial(overwrite, materialId, 0)
				if sleeves1~= "" then
					setMaterial(sleeves1, materialId, 0)
					setMaterial(sleeves2, materialId, 0)
					setMaterial(sleeves3, materialId, 0)
					if hat ~= "" then
						setMaterial(hat, materialId, 0)
					end
				end
				updateColors(overwrite, self.topConfig.items[self.topConfig.selection], self.topConfig.color)
				updateColors(itemAttachNode, self.topConfig.items[self.topConfig.selection], self.topConfig.color)
			end
		else
			updateColors(itemAttachNode, self.topConfig.items[self.topConfig.selection], self.topConfig.color)
		end
	end

	local bottomNode = nil

	if self.bottomConfig.selection ~= 0 then
		bottomNode = enable(self.bottomConfig.items[self.bottomConfig.selection], self.footwearConfig.selection ~= 0 and self.footwearConfig.items[self.footwearConfig.selection].extent or "low")
		local bottom = self.bottomConfig.items[self.bottomConfig.selection]
		if bottom.uvSlot > 300 then
			local overwrite = ""
			local overwrite1 = ""
			local overwrite2 = ""
			local overwrite3 = ""
			local overwrite4 = ""
			if bottom.filename == "dataS/character/player02/clothes/bottoms/botCargo.i3d" or bottom.filename == "dataS/character/player01/clothes/bottoms/botCargo.i3d" or bottom.filename == "dataS/character/player02/clothes/bottoms/botChinos.i3d" or bottom.filename == "dataS/character/player01/clothes/bottoms/botChinos.i3d" or bottom.filename == "dataS/character/player01/brands/brand08/engelbertStraussMotion2020Pants.i3d" or bottom.filename == "dataS/character/player01/brands/brand08/engelbertStraussMotionPants.i3d" or bottom.filename == "dataS/character/player01/brands/brand08/engelbertStraussConcretePants.i3d" or bottom.filename == "dataS/character/player02/clothes/bottoms/botLeather.i3d" or bottom.filename == "dataS/character/player01/clothes/bottoms/botLeather.i3d" then
				overwrite = I3DUtil.getChildByName(bottomNode, "BeltAndStraps")
				overwrite1 = I3DUtil.getChildByName(bottomNode, "botCutOff")
				overwrite2 = I3DUtil.getChildByName(bottomNode, "bottom")
				overwrite3 = I3DUtil.getChildByName(bottomNode, "top")
				overwrite4 = I3DUtil.getChildByName(bottomNode, "bottom2")
			elseif bottom.filename == "dataS/character/player02/brands/brand08/engelbertStraussConcretePants.i3d" then
				overwrite = I3DUtil.getChildByName(bottomNode, "concretePants")
				overwrite1 = I3DUtil.getChildByName(bottomNode, "BeltAndStraps")
				overwrite2 = I3DUtil.getChildByName(bottomNode, "botCutOff")
				overwrite3 = I3DUtil.getChildByName(bottomNode, "bottom")
				overwrite4 = I3DUtil.getChildByName(bottomNode, "bottom2")
			elseif bottom.filename == "dataS/character/player02/brands/brand08/engelbertStraussMotionPants.i3d" then
				overwrite = I3DUtil.getChildByName(bottomNode, "motionPants")
				overwrite1 = I3DUtil.getChildByName(bottomNode, "BeltAndStraps")
				overwrite2 = I3DUtil.getChildByName(bottomNode, "botCutOff")
				overwrite3 = I3DUtil.getChildByName(bottomNode, "bottom")
				overwrite4 = I3DUtil.getChildByName(bottomNode, "bottom2")
			elseif bottom.filename == "dataS/character/player02/brands/brand08/engelbertStraussMotion2020Pants.i3d" then
				overwrite = I3DUtil.getChildByName(bottomNode, "top")
				overwrite1 = I3DUtil.getChildByName(bottomNode, "BeltAndStraps")
				overwrite2 = I3DUtil.getChildByName(bottomNode, "botCutOff")
				overwrite3 = I3DUtil.getChildByName(bottomNode, "bottom")
				overwrite4 = I3DUtil.getChildByName(bottomNode, "bottom2")
			elseif bottom.filename == "dataS/character/player01/clothes/bottoms/botJeans.i3d" then
				overwrite = I3DUtil.getChildByName(bottomNode, "BeltAndStraps")
				overwrite1 = I3DUtil.getChildByName(bottomNode, "botCutOff")
				overwrite2 = I3DUtil.getChildByName(bottomNode, "bottom")
				overwrite3 = I3DUtil.getChildByName(bottomNode, "top")
				overwrite4 = I3DUtil.getChildByName(bottomNode, "bottom02")
			elseif bottom.filename == "dataS/character/player02/clothes/bottoms/botJeans.i3d" then
				overwrite = I3DUtil.getChildByName(bottomNode, "BeltAndStraps")
				overwrite1 = I3DUtil.getChildByName(bottomNode, "botCutOff")
				overwrite2 = I3DUtil.getChildByName(bottomNode, "bottom")
				overwrite3 = I3DUtil.getChildByName(bottomNode, "top")
				overwrite4 = I3DUtil.getChildByName(bottomNode, "bottom2")
			else
				local materialId = getMaterial(bottomNode, 0)
				materialId = setMaterialDiffuseMapFromFile(materialId, PlayerStyle.FAMerchStore.diffuses[bottom.uvSlot], true, true, false)
				materialId = setMaterialCustomMapFromFile(materialId, "mMaskMap", PlayerStyle.FAMerchStore.masks[bottom.uvSlot], true, true, false)
				setMaterial(bottomNode, materialId, 0)
				updateColors(bottomNode, self.bottomConfig.items[self.bottomConfig.selection], self.bottomConfig.color)
			end

			if overwrite ~= "" then
				local materialId = getMaterial(overwrite, 0)
				materialId = setMaterialDiffuseMapFromFile(materialId, PlayerStyle.FAMerchStore.diffuses[bottom.uvSlot], true, true, false)
				materialId = setMaterialCustomMapFromFile(materialId, "mMaskMap", PlayerStyle.FAMerchStore.masks[bottom.uvSlot], true, true, false)
				setMaterial(overwrite, materialId, 0)
				if overwrite1~= "" then
					setMaterial(overwrite1, materialId, 0)
					setMaterial(overwrite2, materialId, 0)
					setMaterial(overwrite3, materialId, 0)
					setMaterial(overwrite4, materialId, 0)
				end
				updateColors(overwrite, self.bottomConfig.items[self.bottomConfig.selection], self.bottomConfig.color)
				updateColors(bottomNode, self.bottomConfig.items[self.bottomConfig.selection], self.bottomConfig.color)
			end
		else
			updateColors(bottomNode, self.bottomConfig.items[self.bottomConfig.selection], self.bottomConfig.color)
		end
	end

	if self.footwearConfig.selection ~= 0 then
		local extent = "high"

		if self.bottomConfig.selection ~= 0 then
			extent = self.bottomConfig.items[self.bottomConfig.selection].extent
		end

		if self.onepieceConfig.selection ~= 0 then
			extent = self.onepieceConfig.items[self.onepieceConfig.selection].extent
		end

		local item = self.footwearConfig.items[self.footwearConfig.selection]
		local itemAttachNode = enable(item, extent)

		updateColors(itemAttachNode, item, self.footwearConfig.color)
	end

	if self.glovesConfig.selection ~= 0 then
		local item = self.glovesConfig.items[self.glovesConfig.selection]
		local itemAttachNode = enable(item)

		updateColors(itemAttachNode, item, self.glovesConfig.color)
	end

	local hideGlasses = false

	if self.invisible == false then
		if self.headgearConfig.selection ~= 0 then
			local item = self.headgearConfig.items[self.headgearConfig.selection]
			local itemAttachNode = enable(item)

			local headgear = self.headgearConfig.items[self.headgearConfig.selection]
			if headgear.uvSlot > 300 then
				local materialId = getMaterial(itemAttachNode, 0)
				materialId = setMaterialDiffuseMapFromFile(materialId, PlayerStyle.FAMerchStore.diffuses[headgear.uvSlot], true, true, false)
				materialId = setMaterialCustomMapFromFile(materialId, "mMaskMap", PlayerStyle.FAMerchStore.masks[headgear.uvSlot], true, true, false)
				setMaterial(itemAttachNode, materialId, 0)
			end
			updateColors(itemAttachNode, item, self.headgearConfig.color)

			if item.hideGlasses then
				hideGlasses = true
			end
		end

		if self.glassesConfig.selection ~= 0 and not hideGlasses then
			enable(self.glassesConfig.items[self.glassesConfig.selection])
		end
	end

	if self.hairStyleConfig.selection ~= 0 then
		if (self.headgearConfig.selection ~= 0 or self.onepieceConfig.selection ~= 0 and self.onepieceConfig.items[self.onepieceConfig.selection].disabledOptions.headgear) and self.hatHairstyleIndex ~= nil then
			local item = self.hairStyleConfig.items[self.hatHairstyleIndex]
			local itemNode, itemNode2 = enable(item)

			updateHairColors(itemNode, item)
			updateHairColors(itemNode2, item)
		else
			local item = self.hairStyleConfig.items[self.hairStyleConfig.selection]
			local itemNode, itemNode2 = enable(item)

			updateHairColors(itemNode, item)
			updateHairColors(itemNode2, item)
		end
	end

	if self.invisible == false then
		if self.facegearConfig.selection ~= 0 then
			enable(self.facegearConfig.items[self.facegearConfig.selection])
		else
			if self.mustacheConfig.selection ~= 0 then
				for i = self.mustacheConfig.selection, #self.mustacheConfig.items do
					local item = self.mustacheConfig.items[i]

					if item.face == nil or item.face == self.faceConfig.selection or self.faceConfig.selection == 0 and item.face == 1 then
						local itemNode, itemNode2 = enable(item)

						updateHairColors(itemNode, item)
						updateHairColors(itemNode2, item)

						break
					end
				end
			end

			if self.beardConfig.selection ~= 0 then
				for i = self.beardConfig.selection, #self.beardConfig.items do
					local item = self.beardConfig.items[i]

					if item.face == nil or item.face == self.faceConfig.selection or self.faceConfig.selection == 0 and item.face == 1 then
						local itemNode, itemNode2 = enable(item)

						updateHairColors(itemNode, item)
						updateHairColors(itemNode2, item)

						break
					end
				end
			end
		end
end

	if self.onepieceConfig.selection ~= 0 then
		local itemAttachNode = enable(self.onepieceConfig.items[self.onepieceConfig.selection], self.glovesConfig.selection ~= 0 and self.glovesConfig.items[self.glovesConfig.selection].extent or "hands", self.footwearConfig.selection ~= 0 and self.footwearConfig.items[self.footwearConfig.selection].extent or "low")

		updateColors(itemAttachNode, self.onepieceConfig.items[self.onepieceConfig.selection], self.onepieceConfig.color)
	end

	if (self.topConfig.selection ~= 0 or self.topConfig.selection == 0 and self.onepieceConfig.selection == 0) and self.bottomConfig.selection ~= 0 then
		local bottom = self.bottomConfig.items[self.bottomConfig.selection]
		local beltHidden = false

		if self.topConfig.selection ~= 0 then
			beltHidden = self.topConfig.items[self.topConfig.selection].beltHidden
		end

		if bottom.belt ~= nil then
			local node = I3DUtil.indexToObject(bottomNode, bottom.belt)

			setVisibility(node, not beltHidden)
		end
	end

end

PlayerStyle.apply = Utils.overwrittenFunction(PlayerStyle.apply, FAMerchStore.apply)



--Neue Kleidung in den Kleiderschrank einfügen
function FAMerchStore.loadClothing(self, superFunc, xmlFile, rootKey, itemKey, configName, isColorable, isHair, isFaceSpecific, isHeadgear, resetToOne)
	if itemKey == "top" or itemKey == "headgear" or itemKey == "bottom" then
		local fileName = xmlFile:getFilename()
		local topsbefore = 0
		local headgearbefore = 0
		local bottombefore = 0

		--Anzahl vorhandener Einträge auslesen
		xmlFile:iterate(rootKey .. ".top", function (_, key)
			topsbefore = topsbefore + 1
		end)
		xmlFile:iterate(rootKey .. ".headgear", function (_, key)
			headgearbefore = headgearbefore + 1
		end)
		xmlFile:iterate(rootKey .. ".bottom", function (_, key)
			bottombefore = bottombefore + 1
		end)

		local function addStyle(xmlFile, gender, x, itemKey, headgearbefore, topsbefore, bottombefore)
			if PlayerStyle.FAMerchStore.type[x] == itemKey and itemKey == "headgear" then
				xmlFile:setString(rootKey .. ".headgear("..headgearbefore..")#node", "1")
				xmlFile:setString(rootKey .. ".headgear("..headgearbefore..")#attachPoint", "head")
				xmlFile:setFloat(rootKey .. ".headgear("..headgearbefore..")#uvSlot", x)
				xmlFile:setString(rootKey .. ".headgear("..headgearbefore..")#name", PlayerStyle.FAMerchStore.modName[x])
				if gender == 2 then
					xmlFile:setString(rootKey .. ".headgear("..headgearbefore..")#filename", PlayerStyle.FAMerchStore.filenameFemale[x])
				else
					xmlFile:setString(rootKey .. ".headgear("..headgearbefore..")#filename", PlayerStyle.FAMerchStore.filenameMale[x])
				end
				xmlFile:setString(rootKey .. ".headgear("..headgearbefore..")#iconOffset", PlayerStyle.FAMerchStore.iconOffset[x])
				xmlFile:setString(rootKey .. ".headgear("..headgearbefore..")#colorable", PlayerStyle.FAMerchStore.colorable[x])
				xmlFile:setString(rootKey .. ".headgear("..headgearbefore..")#defaultPrimary", PlayerStyle.FAMerchStore.defaultPrimary[x])
				if #PlayerStyle.FAMerchStore.colorsPrimary[x] > 0 then
					local primary = PlayerStyle.FAMerchStore.colorsPrimary[x]
					for y = 1, #primary do
						xmlFile:setString(rootKey .. ".headgear("..headgearbefore..").colors.color("..(y - 1)..")#primary", primary[y])
					end
					if #PlayerStyle.FAMerchStore.colorsSecondary[x] > 0 then
						local secondary = PlayerStyle.FAMerchStore.colorsSecondary[x]
						for y = 1, #secondary do
							xmlFile:setString(rootKey .. ".headgear("..headgearbefore..").colors.color("..(y - 1)..")#secondary", secondary[y])
						end
					end
				end

				headgearbefore = headgearbefore + 1

			elseif PlayerStyle.FAMerchStore.type[x] == itemKey and itemKey == "top" then
				if (PlayerStyle.FAMerchStore.filenameFemale[x] ~= nil and gender == 2) or (PlayerStyle.FAMerchStore.filenameMale[x] ~= nil and gender == 1) then
					xmlFile:setString(rootKey .. ".top("..topsbefore..")#node", "1|0|0|0")
					xmlFile:setString(rootKey .. ".top("..topsbefore..")#attachPoint", "geo")
					xmlFile:setFloat(rootKey .. ".top("..topsbefore..")#uvSlot", x)
					xmlFile:setString(rootKey .. ".top("..topsbefore..")#name", PlayerStyle.FAMerchStore.modName[x])
					if gender == 2 then
						xmlFile:setString(rootKey .. ".top("..topsbefore..")#filename", PlayerStyle.FAMerchStore.filenameFemale[x])
					else
						xmlFile:setString(rootKey .. ".top("..topsbefore..")#filename", PlayerStyle.FAMerchStore.filenameMale[x])
					end
					xmlFile:setString(rootKey .. ".top("..topsbefore..")#beltHidden", PlayerStyle.FAMerchStore.beltHidden[x])
					xmlFile:setString(rootKey .. ".top("..topsbefore..")#colorable", PlayerStyle.FAMerchStore.colorable[x])
					xmlFile:setString(rootKey .. ".top("..topsbefore..")#defaultPrimary", PlayerStyle.FAMerchStore.defaultPrimary[x])
					if #PlayerStyle.FAMerchStore.colorsPrimary[x] > 0 then
						local primary = PlayerStyle.FAMerchStore.colorsPrimary[x]
						local secondary = PlayerStyle.FAMerchStore.colorsSecondary[x]
						for y = 1, #primary do
							xmlFile:setString(rootKey .. ".top("..topsbefore..").colors.color("..(y - 1)..")#primary", primary[y])
						end
						for y = 1, #secondary do
							xmlFile:setString(rootKey .. ".top("..topsbefore..").colors.color("..(y - 1)..")#secondary", secondary[y])
						end
					end
					if #PlayerStyle.FAMerchStore.hidesBodypart[x] > 0 then
						local bodyPart = PlayerStyle.FAMerchStore.hidesBodypart[x]
						if #bodyPart > 0 then
							for y = 1, #bodyPart do
								xmlFile:setString(rootKey .. ".top("..topsbefore..").hidesBodypart("..(y - 1)..")#name", bodyPart[y])
							end
						end
					end
					if #PlayerStyle.FAMerchStore.extent[x] > 0 then
						local extends = PlayerStyle.FAMerchStore.extent[x]
						if #extends > 0 then
							for y = 1, #extends do
								local extend = string.split(extends[y], " ")
								xmlFile:setString(rootKey .. ".top("..topsbefore..").extent("..(y - 1)..")#node", extend[1])
								xmlFile:setString(rootKey .. ".top("..topsbefore..").extent("..(y - 1)..")#type", extend[2])
							end
						end
					end

					topsbefore = topsbefore + 1

				end
			elseif PlayerStyle.FAMerchStore.type[x] == itemKey and itemKey == "bottom" then
				xmlFile:setString(rootKey .. ".bottom("..bottombefore..")#node", "1|0|0|0")
				xmlFile:setString(rootKey .. ".bottom("..bottombefore..")#attachPoint", "geo")
				xmlFile:setString(rootKey .. ".bottom("..bottombefore..")#extent", PlayerStyle.FAMerchStore.lowHigh[x])
				xmlFile:setFloat(rootKey .. ".bottom("..bottombefore..")#uvSlot", x)
				xmlFile:setString(rootKey .. ".bottom("..bottombefore..")#name", PlayerStyle.FAMerchStore.modName[x])
				if PlayerStyle.FAMerchStore.belt[x] ~= nil then
					xmlFile:setString(rootKey .. ".bottom("..bottombefore..").belt#node", PlayerStyle.FAMerchStore.belt[x])
				end
				if gender == 2 then
					xmlFile:setString(rootKey .. ".bottom("..bottombefore..")#filename", PlayerStyle.FAMerchStore.filenameFemale[x])
				else
					xmlFile:setString(rootKey .. ".bottom("..bottombefore..")#filename", PlayerStyle.FAMerchStore.filenameMale[x])
				end

				xmlFile:setString(rootKey .. ".bottom("..bottombefore..")#colorable", PlayerStyle.FAMerchStore.colorable[x])
				xmlFile:setString(rootKey .. ".bottom("..bottombefore..")#defaultPrimary", PlayerStyle.FAMerchStore.defaultPrimary[x])
				if #PlayerStyle.FAMerchStore.colorsPrimary[x] > 0 then
					local primary = PlayerStyle.FAMerchStore.colorsPrimary[x]
					for y = 1, #primary do
						xmlFile:setString(rootKey .. ".bottom("..bottombefore..").colors.color("..(y - 1)..")#primary", primary[y])
					end
					if #PlayerStyle.FAMerchStore.colorsSecondary[x] > 0 then
						local secondary = PlayerStyle.FAMerchStore.colorsSecondary[x]
						for y = 1, #secondary do
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").colors.color("..(y - 1)..")#secondary", secondary[y])
						end
					end
				end
				if #PlayerStyle.FAMerchStore.hidesBodypart[x] > 0 then
					local bodyPart = PlayerStyle.FAMerchStore.hidesBodypart[x]
					if #bodyPart > 0 then
						for y = 1, #bodyPart do
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").hidesBodypart("..(y - 1)..")#name", bodyPart[y])
						end
					end
				end
				if #PlayerStyle.FAMerchStore.extent[x] > 0 then
					local extends = PlayerStyle.FAMerchStore.extent[x]
					if #extends > 0 then
						if PlayerStyle.FAMerchStore.filenameFemale[x] == "dataS/character/player02/clothes/bottoms/botLeather.i3d" and gender == 2 then
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent(0)#node", "1")
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent(0)#type", "low")
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent(1)#node", "1")
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent(1)#type", "low2")
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent(2)#node", "1")
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent(2)#type", "high")
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent(3)#node", "4")
							xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent(3)#type", "cowboy")
						else
							for y = 1, #extends do
								local extend = string.split(extends[y], " ")
								xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent("..(y - 1)..")#node", extend[1])
								xmlFile:setString(rootKey .. ".bottom("..bottombefore..").extent("..(y - 1)..")#type", extend[2])
							end
						end
					end
				end
				bottombefore = bottombefore + 1
			end

			return headgearbefore, topsbefore, bottombefore
		end
		
		for x = 301, PlayerStyle.FAMerchStore.maxUV do
			if fileName == "dataS/character/humans/player/player02.xml" then
				headgearbefore, topsbefore, bottombefore = addStyle(xmlFile, 2, x, itemKey, headgearbefore, topsbefore, bottombefore)
			elseif fileName == "dataS/character/humans/player/player01.xml" then
				headgearbefore, topsbefore, bottombefore = addStyle(xmlFile, 1, x, itemKey, headgearbefore, topsbefore, bottombefore)
			end
		end
	end

	return superFunc(self, xmlFile, rootKey, itemKey, configName, isColorable, isHair, isFaceSpecific, isHeadgear, resetToOne)
end

PlayerStyle.loadClothing = Utils.overwrittenFunction(PlayerStyle.loadClothing, FAMerchStore.loadClothing)



--Übersichts-Bild austauschen
function FAMerchStore:populateCellForItemInSection(superFunc, list, section, index, cell)
	local itemIndex = self.indexMapping[section][index]
	local item = self.playerStyle[self.configName].items[itemIndex]
	local icon = cell:getAttribute("icon")
	local uvSlot = item.uvSlot
	if item.iconFilename ~= nil then
		icon:setImageFilename(item.iconFilename)
	else
		icon:setImageFilename(self.playerStyle.atlasFilename)

		if item.uvSlot > 300 then
			--UV 500 -> ein Bild
			--UV 501 -> zwei Bilder, links
			--UV 502 -> zwei Bilder, rechts
			if item.filename == "dataS/character/player01/clothes/tops/topTeeShirt.i3d" or item.filename == "dataS/character/player02/clothes/tops/topTeeShirt.i3d" or item.filename == "dataS/character/player01/clothes/tops/topPuffJacket.i3d" or item.filename == "dataS/character/player02/clothes/tops/topPuffyJacket.i3d" or item.filename == "dataS/character/player02/clothes/tops/topPlaidShirt01.i3d" or item.filename == "dataS/character/player01/clothes/tops/topPlaidShirt01.i3d" or item.filename == "dataS/character/player02/clothes/tops/topWoolCoat.i3d" or item.filename == "dataS/character/player01/clothes/tops/topDeckJacket.i3d" then
				uvSlot = 500
			elseif string.find(item.filename, "attachments") then
				uvSlot = 500
			elseif string.find(item.filename, "player01") then
				uvSlot = 502
			else
				uvSlot = 501
			end
			local filename = PlayerStyle.FAMerchStore.icons[item.uvSlot]
			icon:setImageFilename(filename)
		end
	end

	icon:setImageUVs(nil, self.playerStyle:getSlotUVs(uvSlot))
	cell:getAttribute("selected"):setVisible(self.savedPlayerStyle[self.configName].selection == itemIndex)
	cell:getAttribute("hasColors"):setVisible(item.numColors > 0)
end

WardrobeItemsFrame.populateCellForItemInSection = Utils.overwrittenFunction(WardrobeItemsFrame.populateCellForItemInSection, FAMerchStore.populateCellForItemInSection)



--UV-Slot-Nummer anpassen
function FAMerchStore:getSlotUVs(superFunc, slot)
	if slot == 0 or slot == nil then
		slot = 1
	end
	local rows = PlayerStyle.ATLAS_ROWS
	local columns = PlayerStyle.ATLAS_COLUMNS

	if slot > 300 then
		rows = 1
		if slot == 501 then
			slot = 0
			columns = 2
		elseif slot == 502 then
			slot = 1
			columns = 2
		else
			columns = 1
			slot = 0
		end
	else
		slot = slot - 1
	end

	local slotU = math.floor(slot / rows)
	local slotV = slot % rows
	local u = slotU / columns
	local v = slotV / rows
	local uvs = GuiUtils.getNormalizedValues(u .. " " .. v .. " " .. 1 / columns .. " " .. 1 / rows, {
		columns,
		rows
	})

	return uvs[1], 1 - uvs[2] - uvs[4], uvs[1], 1 - uvs[2], uvs[1] + uvs[3], 1 - uvs[2] - uvs[4], uvs[1] + uvs[3], 1 - uvs[2]
end

PlayerStyle.getSlotUVs = Utils.overwrittenFunction(PlayerStyle.getSlotUVs, FAMerchStore.getSlotUVs)



--PlayerStyle bei neuen Savegames erneut laden, damit die neue Kleidung vorhanden ist
function FAMerchStore:isValid(superFunc)
	if g_currentMission.missionInfo.isValid == false then
		if g_savegameXML ~= nil then
			local xmlFile = loadXMLFile("savegameXML", g_savegamePath)
			xmlFile = XMLFile.wrap(xmlFile)
			if xmlFile:hasProperty("gameSettings.lastPlayerStyle") then
				self:loadConfigurationXML(self.xmlFilename)
				self:loadFromXMLFile(xmlFile, "gameSettings.lastPlayerStyle")
			end
		end
	end

	return superFunc(self)
end

PlayerStyle.isValid = Utils.overwrittenFunction(PlayerStyle.isValid, FAMerchStore.isValid)


function FAMerchStore:drawUIInfo()
	if self.isClient and self.isControlled and not self.isEntered and not g_gui:getIsGuiVisible() and not g_noHudModeEnabled and g_gameSettings:getValue(GameSettings.SETTING.SHOW_MULTIPLAYER_NAMES) then
		if self.model.style.invisible == nil or self.model.style.invisible == false then
			local x, y, z = getTranslation(self.graphicsRootNode)
			local x1, y1, z1 = getWorldTranslation(getCamera())
			local diffX = x - x1
			local diffY = y - y1
			local diffZ = z - z1
			local dist = MathUtil.vector3LengthSq(diffX, diffY, diffZ)

			if dist <= 10000 then
				y = y + self.baseInformation.tagOffset[2]
				local user = g_currentMission.userManager:getUserByUserId(self.userId)

				if user ~= nil then
					Utils.renderTextAtWorldPosition(x, y, z, user:getNickname(), getCorrectTextSize(0.02), 0)
				end
			end
		end
	end
end

Player.drawUIInfo = Utils.overwrittenFunction(Player.drawUIInfo, FAMerchStore.drawUIInfo)

print("Wardrobe Plus loaded")