-- Name: CCUP_LoadTrigger
-- Author: Chissel

CCUP_LoadTrigger = {}

function CCUP_LoadTrigger:init()
    LoadTrigger.setSource = Utils.overwrittenFunction(LoadTrigger.setSource, function (self, superFunc, object)
        assert(object.getSupportedFillTypes ~= nil)
        assert(object.getAllFillLevels ~= nil)
        assert(object.addFillLevelToFillableObject ~= nil)
        assert(object.getIsFillAllowedToFarm ~= nil)

        object.getIsFillAllowedToFarm = Utils.overwrittenFunction(object.getIsFillAllowedToFarm, function (self, superFunc, farmId)
            if superFunc(self, farmId) then
                return true
            else
                local ccupUseSuperFunc = self.ccupUseSuperFunc or false
                if ccupUseSuperFunc then
                    return false
                else
                    return CCUP_LoadTrigger:isContractingFor(farmId, self.ownerFarmId)
                end
            end
        end)

        object.getAllFillLevels = Utils.overwrittenFunction(object.getAllFillLevels, function (self, superFunc, farmId)
            local isContracting = CCUP_LoadTrigger:isContractingFor(farmId, self.ownerFarmId)

            if isContracting then
                return superFunc(self, self.ownerFarmId)
            else
                return superFunc(self, farmId)
            end
        end)

        object.addFillLevelToFillableObject = Utils.overwrittenFunction(object.addFillLevelToFillableObject, function (self, superFunc, fillableObject, fillUnitIndex, fillTypeIndex, fillDelta, fillInfo, toolType)
            self.ccupUseSuperFunc = true

            if self:getIsFillAllowedToFarm(fillableObject:getActiveFarm()) then
                self.ccupUseSuperFunc = false
                return superFunc(self, fillableObject, fillUnitIndex, fillTypeIndex, fillDelta, fillInfo, toolType)
            elseif CCUP_LoadTrigger:isContractingFor(fillableObject:getActiveFarm(), self.ownerFarmId) then
                self.ccupUseSuperFunc = false
                local activeFarmFunc = fillableObject.getActiveFarm

                fillableObject.ccupActiveFarmId = self.ownerFarmId
                fillableObject.getActiveFarm = Utils.overwrittenFunction(fillableObject.getActiveFarm, function (self, superFunc)
                    return fillableObject.ccupActiveFarmId or 0
                end)

                local superfillDelta = superFunc(self, fillableObject, fillUnitIndex, fillTypeIndex, fillDelta, fillInfo, toolType)

                fillableObject.getActiveFarm = activeFarmFunc
                fillableObject.ccupActiveFarmId  = nil
                return superfillDelta
            end

            self.ccupUseSuperFunc = false
            return superFunc(self, fillableObject, fillUnitIndex, fillTypeIndex, fillDelta, fillInfo, toolType)
        end)

        self.source = object
    end)
end

function CCUP_LoadTrigger:isContractingFor(vehicleOwnerFarmId, ownerFarmId)
    if ownerFarmId ~= nil and vehicleOwnerFarmId ~= nil then
        local vehicleOwnerFarm = g_farmManager:getFarmById(vehicleOwnerFarmId)
        if vehicleOwnerFarm ~= nil then
            local isAllow = vehicleOwnerFarm:getIsContractingFor(ownerFarmId)
            return isAllow
        end
    end

    return false
end