DigitalSign = {};

local MaxSingleLineChars = 10;

function DigitalSign:IsDigitalSign(text)
    if text == "Digital Sign" then return true end;
    if text == "Signe numérique" then return true end;
    if text == "Digitales Zeichen" then return true end;
    if text == "Segno digitale" then return true end;
    if text == "señal digital" then return true end;
    if text == "Znak cyfrowy" then return true end;
    return false;
end;

function DigitalSign:DistanceFrom(x1,y1,x2,y2) return math.sqrt((x2 - x1) ^ 2 + (y2 - y1) ^ 2) end;

function DigitalSign:GetAllSigns()
    Signs = {}
    for i=#g_currentMission.placeableSystem.placeables, 1, -1 do
        local Cplaceable = g_currentMission.placeableSystem.placeables[i];
        if Cplaceable ~= nil and DigitalSign:IsDigitalSign(Cplaceable.storeItem.name) then
            Signs[table.getn(Signs) + 1] = Cplaceable;
        end;
    end
    return Signs;
end;

function DigitalSign:GetSignInRange()
    local Px, Py, Pz = getTranslation(g_currentMission.player.rootNode);

    local AllSigns = DigitalSign:GetAllSigns();
    if AllSigns == nil or table.getn(AllSigns) < 1 then return; end;
    
    for i = 1, table.getn(AllSigns) do
        local CurrentSign = AllSigns[i];

        if DigitalSign:DistanceFrom(Px,Pz,CurrentSign.position.x,CurrentSign.position.z) < 1 and CurrentSign:getOwnerFarmId() == g_currentMission.player.farmId then
            return CurrentSign;
        end;
    end;

    return nil;
end;

function DigitalSign:FormatText(Text)
    for i=1,(MaxSingleLineChars-string.len(Text))/2 do
        Text = "_"..Text.."_";
    end

    return Text;
end;

local TimerI = 0;
local MaxTimerI = g_gameSettings:getValue(GameSettings.SETTING.FRAME_LIMIT);

function DigitalSign:Timer()
    TimerI = TimerI + 1;
    if TimerI < MaxTimerI then return false; end;
    TimerI = 0;
    return true;
end;

function DigitalSign:update()	
    --print(g_currentMission.snowSystem.height);
    if not DigitalSign:Timer() then return; end;
    DigitalSign:UpdateSnowSigns();
    DigitalSign:InitSings();
    DigitalSign:UpdateTexts();
    DigitalSign:UpdateSplits();
end;

function DigitalSign:loadMap()
	if g_currentMission:getIsClient() then
		Player.registerActionEvents = Utils.appendedFunction(Player.registerActionEvents, DigitalSign.RegisterActionEvents);
        Player.updateActionEvents = Utils.appendedFunction(Player.updateActionEvents, DigitalSign.UpdateActionEvents);
	end;
end;

function DigitalSign:UpdateSnowSigns()

end;

local RenameEventId = nil;
local ColorEventId = nil;

function DigitalSign:RegisterActionEvents()
    if self.isClient then
        DigitalSign.events = {}
		local valid1, eventId1 = g_inputBinding:registerActionEvent(InputAction.RENAMEACTION,"RENAMEACTION",DigitalSign.RenameEvent,false,true,false,true)
        if valid1 then
            table.insert(DigitalSign.events, eventId1);
            g_inputBinding:setActionEventTextVisibility(eventId1, true);
            RenameEventId = eventId1;
        end
        local valid2, eventId2 = g_inputBinding:registerActionEvent(InputAction.COLORACTION,"COLORACTION",DigitalSign.ColorEvent,false,true,false,true)
        if valid2 then
            table.insert(DigitalSign.events, eventId2);
            g_inputBinding:setActionEventTextVisibility(eventId2, true);
            ColorEventId = eventId2;
        end
    end
end

function DigitalSign:UpdateActionEvents()
	if RenameEventId ~= nil and ColorEventId ~= nil then
        local InRange = DigitalSign:GetSignInRange();
        g_inputBinding:setActionEventActive(RenameEventId, InRange ~= nil)
        g_inputBinding:setActionEventActive(ColorEventId, false);--TODO
	end;
end

function DigitalSign:RenameEvent(actionName, keyStatus, arg3, arg4, arg5)
    local InRange = DigitalSign:GetSignInRange();
    if InRange == nil then return; end;
    g_gui:showTextInputDialog({
        text = g_i18n:getText("input_RENAMEACTION"),
        defaultText = InRange:getName(),
        callback = function(text,yes)
            InRange:setName(text, false);
        end
    });
end

function DigitalSign:ColorEvent(actionName, keyStatus, arg3, arg4, arg5)
    --TODO UPDATES
end

function DigitalSign:InitSings()
    local AllSigns = DigitalSign:GetAllSigns();
    if AllSigns == nil or table.getn(AllSigns) < 1 then return; end;
    
    for i = 1, table.getn(AllSigns) do
        local CurrentSign = AllSigns[i];

        if CurrentSign.FontMaterialN == nil or CurrentSign.CharacterLineN == nil then 
            local TextNode = getChildAt(getChildAt(getChildAt(CurrentSign.rootNode, 0), 0), 0);
            local FontMaterial = g_materialManager:getFontMaterial("DIGIT", CurrentSign.customEnvironment);
            local alignment = RenderText.ALIGN_CENTER;
            local size = 0.11;
            local scaleX = 1;
            local scaleY = 1;
            local maxChar = 10;
            local emissiveScale = 0.2;
            local color = {  1,1,1,1}

            CurrentSign.FontMaterialN = FontMaterial;
            CurrentSign.CharacterLineN = FontMaterial:createCharacterLine(TextNode, MaxSingleLineChars, size, color, nil, emissiveScale, scaleX, scaleY, alignment);
        end;

        if CurrentSign.FontMaterialS == nil or CurrentSign.CharacterLineS == nil then 
            local TextNode = getChildAt(getChildAt(getChildAt(CurrentSign.rootNode, 0), 0), 1);
            local FontMaterial = g_materialManager:getFontMaterial("DIGIT", CurrentSign.customEnvironment);
            local alignment = RenderText.ALIGN_CENTER;
            local size = 0.11;
            local scaleX = 1;
            local scaleY = 1;
            local maxChar = 10;
            local emissiveScale = 0.2;
            local color = {  1,1,1,1}

            CurrentSign.FontMaterialS = FontMaterial;
            CurrentSign.CharacterLineS = FontMaterial:createCharacterLine(TextNode, MaxSingleLineChars, size, color, nil, emissiveScale, scaleX, scaleY, alignment);
        end;
    end;
end;

function DigitalSign:UpdateTexts()
    local AllSigns = DigitalSign:GetAllSigns();
    if AllSigns == nil or table.getn(AllSigns) < 1 then return; end;
    
    for i = 1, table.getn(AllSigns) do
        local CurrentSign = AllSigns[i];
        if CurrentSign.CharacterLineN ~= nil and CurrentSign.FontMaterialN ~= nil and CurrentSign.CharacterLineS ~= nil and CurrentSign.FontMaterialS ~= nil then 
            local Text = CurrentSign:getName();
            if string.len(Text) <= MaxSingleLineChars and CurrentSign.Text~=Text then
                CurrentSign.Text = Text;
                CurrentSign.FontMaterialN:updateCharacterLine(CurrentSign.CharacterLineN, DigitalSign:FormatText(Text));
                CurrentSign.FontMaterialS:updateCharacterLine(CurrentSign.CharacterLineS, DigitalSign:FormatText(Text));
                CurrentSign.Words = nil;
            end;
            if string.len(Text) > MaxSingleLineChars and CurrentSign.Text~=Text then
                CurrentSign.Words = {};
                CurrentSign.SplitI = 0;
                CurrentSign.Text = Text;
                for word in Text:gmatch("%w+") do
                    CurrentSign.Words[table.getn(CurrentSign.Words) + 1] = word;
                end;
            end;
        end;

    end;
end;

function DigitalSign:UpdateSplits()
    local AllSigns = DigitalSign:GetAllSigns();
    if AllSigns == nil or table.getn(AllSigns) < 1 then return; end;
    
    for i = 1, table.getn(AllSigns) do
        local CurrentSign = AllSigns[i];
        if CurrentSign.SplitI ~=nil and CurrentSign.Words ~=nil and CurrentSign.CharacterLineN ~= nil and CurrentSign.FontMaterialN ~= nil and CurrentSign.CharacterLineS ~= nil and CurrentSign.FontMaterialS ~= nil then 

            if CurrentSign.SplitI > table.getn(CurrentSign.Words)-1 then CurrentSign.SplitI = 0; end;
            CurrentSign.SplitI = CurrentSign.SplitI + 1;
            local Word = CurrentSign.Words[CurrentSign.SplitI];

            CurrentSign.FontMaterialN:updateCharacterLine(CurrentSign.CharacterLineN, DigitalSign:FormatText(Word));
            CurrentSign.FontMaterialS:updateCharacterLine(CurrentSign.CharacterLineS, DigitalSign:FormatText(Word));
        end;

    end;
end;

addModEventListener(DigitalSign);