--[[
Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 07.04.2019
Revision: FS22-02

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

EasyDevControlsSuperStrengthEvent = {}

local EasyDevControlsSuperStrengthEvent_mt = Class(EasyDevControlsSuperStrengthEvent, Event)
InitEventClass(EasyDevControlsSuperStrengthEvent, "EasyDevControlsSuperStrengthEvent")

function EasyDevControlsSuperStrengthEvent.emptyNew()
    local self = Event.new(EasyDevControlsSuperStrengthEvent_mt)

    return self
end

function EasyDevControlsSuperStrengthEvent.new(active, userId, isSync)
    local self = EasyDevControlsSuperStrengthEvent.emptyNew()

    self.active = active
    self.userId = userId
    self.isSync = isSync

    return self
end

function EasyDevControlsSuperStrengthEvent:readStream(streamId, connection)
    self.active = streamReadBool(streamId)

    if streamReadBool(streamId) then
        self.userId = streamReadInt32(streamId)
    end

    self.isSync = streamReadBool(streamId)

    self:run(connection)
end

function EasyDevControlsSuperStrengthEvent:writeStream(streamId, connection)
    streamWriteBool(streamId, self.active)

    if streamWriteBool(streamId, self.userId ~= nil) then
        streamWriteInt32(streamId, self.userId)
    end

    streamWriteBool(streamId, Utils.getNoNil(self.isSync, false))
end

function EasyDevControlsSuperStrengthEvent:run(connection)
    if g_easyDevControls ~= nil then
        if not self.isSync then
            if not connection:getIsServer() then
                self.userId = g_currentMission.userManager:getUserIdByConnection(connection)
                g_server:broadcastEvent(EasyDevControlsSuperStrengthEvent.new(self.active, self.userId, false))
            end

            local message = g_easyDevControls:setSuperStrengthPlayerValues(self.active, self.userId)

            if g_dedicatedServer ~= nil and message ~= nil then
                Logging.info(message)
            end
        elseif not g_easyDevControls.isEnabled then
            g_easyDevControls.superStrengthEnabled = self.active
        end
    end
end

