GoToVacation = {};

function GoToVacation:loadMap(name)

	GoToVacation.Instance = self;

	if g_currentMission:getIsClient() then
        Player.registerActionEvents = Utils.appendedFunction(Player.registerActionEvents, GoToVacation.RegisterActionEvents)
    end
end

function GoToVacation:RegisterActionEvents()	
	local valid, eventId = g_inputBinding:registerActionEvent(InputAction.VACATION,"VACATION",GoToVacation.GoToVacationEvent,false,true,false,false)
	g_inputBinding:setActionEventTextPriority(eventId,GS_PRIO_VERY_HIGH);
	GoToVacation.Instance.VacationEventId = eventId;
end

function GoToVacation:GoToVacationEvent()
	g_gui:showOptionDialog({
		title = g_i18n:getText("input_VACATION"),
		text = g_i18n:getText("text_VacationTarget"),	
		options = {"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"},
		callback = function(selected)
			VacationManager:Start(selected);
		end
	});
end

function GoToVacation:TriggerCallback(triggerId, otherActorId, onEnter, onLeave, onStay, otherShapeId)
    if (onEnter or onLeave) and g_currentMission.player ~= nil and otherActorId == g_currentMission.player.rootNode then
		if self:getOwnerFarmId() == g_currentMission.player.farmId then
			g_inputBinding:setActionEventActive(GoToVacation.Instance.VacationEventId, onEnter);
		end
	end
end

PlaceableFarmhouse.farmhouseSleepingTriggerCallback = Utils.appendedFunction(PlaceableFarmhouse.farmhouseSleepingTriggerCallback, GoToVacation.TriggerCallback)
addModEventListener(GoToVacation);
