VacationManager = {};

source(g_currentModDirectory.."StartVacationEvent.lua");

function VacationManager:loadMap(name)

	VacationManager.Instance = self;

	self.CenterOv = Overlay.new(HUD.MENU_BACKGROUND_PATH, 0, 0, 0, 0);	
	self.TopOv = Overlay.new(HUD.MENU_BACKGROUND_PATH, 0, 0, 0, 0);	
	self.BotOv = Overlay.new(HUD.MENU_BACKGROUND_PATH, 0, 0, 0, 0);	

	g_messageCenter:subscribe(MessageType.DAY_CHANGED, self.DayChange, self)
end;

function VacationManager:DayChange()
	if self.IsOnVacation and self.ElapsedDays ~= nil then
		self.ElapsedDays = self.ElapsedDays + 1;
	end

	if self.VacationDisplay and self.ElapsedDisplay ~= nil then
		self.ElapsedDisplay = self.ElapsedDisplay + 1;
	end
end

function VacationManager:draw()
	if not g_sleepManager:getIsSleeping() then return end
	if not self.VacationDisplay then return end

	setOverlayUVs(self.TopOv.overlayId, 1,1, 1,1, 1,1, 1,1);
	setOverlayUVs(self.CenterOv.overlayId, 1,1, 1,1, 1,1, 1,1);
	setOverlayUVs(self.BotOv.overlayId, 1,1, 1,1, 1,1, 1,1);

	setOverlayColor(self.TopOv.overlayId, 0, 0.776, 0.992, 1);
	setOverlayColor(self.BotOv.overlayId, 0, 0.776, 0.992, 1);
	setOverlayColor(self.CenterOv.overlayId, 0.1, 0.1, 0.1, 1);

	self.CenterOv:setPosition(0,0.5-(0.2/2));
	self.CenterOv:setDimension(1,0.2);
	self.CenterOv:render();

	self.TopOv:setPosition(0,0.6-(0.01/2));
	self.TopOv:setDimension(1,0.01);
	self.TopOv:render();

	self.BotOv:setPosition(0,0.4-(0.01/2));
	self.BotOv:setDimension(1,0.01);
	self.BotOv:render();


	local Text = self.ElapsedDisplay.."/"..self.DaysDisplay.." "..g_i18n:getText("ui_days")
	local TextSize = 0.035;

	setTextColor(1,1,1,1);
	renderText(0.5-(getTextWidth(TextSize,Text)/2), 0.51-(getTextHeight(TextSize,Text)/2), TextSize, Text);
end

function VacationManager:update(dt)
	if not self.IsOnVacation then return end;
	if not g_currentMission:getIsServer() then return; end

	g_sleepManager.wakeUpTime = g_time + 99999999;
		
	if self.ElapsedDays == self.Days then
		self.IsOnVacation = false;
		g_sleepManager:stopSleep()
	end
end

function VacationManager:Start(Days)
	if g_currentMission:getIsServer() then
		self.IsOnVacation = true;
		self.Days = Days;
		self.ElapsedDays = 0;
	
		g_sleepManager:startSleep(-Days);
	else 
		g_client:getServerConnection():sendEvent(StartVacationEvent.new(Days));
	end
end

function VacationManager:VacationDisplayEvent(Time)
	VacationManager.Instance.VacationDisplay = Time < 0;
	VacationManager.Instance.DaysDisplay = math.abs(Time);
	VacationManager.Instance.ElapsedDisplay = 0;
end

SleepManager.startSleep = Utils.appendedFunction(SleepManager.startSleep, VacationManager.VacationDisplayEvent)
addModEventListener(VacationManager);