--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 02.01.2022
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ObjectStorageAddObjectEvent = {}

local ObjectStorageAddObjectEvent_mt = Class(ObjectStorageAddObjectEvent, Event)
InitEventClass(ObjectStorageAddObjectEvent, "ObjectStorageAddObjectEvent")

function ObjectStorageAddObjectEvent.emptyNew()
    local self = Event.new(ObjectStorageAddObjectEvent_mt)

    return self
end

function ObjectStorageAddObjectEvent.new(object, storageAreaIndex, attributes)
    local self = ObjectStorageAddObjectEvent.emptyNew()

    self.object = object
    self.storageAreaIndex = storageAreaIndex
    self.attributes = attributes

    return self
end

function ObjectStorageAddObjectEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.storageAreaIndex = streamReadUIntN(streamId, ObjectStorage.STORAGE_SEND_NUM_BITS)

    local xmlFilename = NetworkUtil.convertFromNetworkFilename(streamReadString(streamId))
    local fillLevel = streamReadFloat32(streamId)
    local capacity = streamReadFloat32(streamId)

    self.attributes = {
        xmlFilename = xmlFilename,
        fillLevel = fillLevel,
        capacity = capacity
    }

    self:run(connection)
end

function ObjectStorageAddObjectEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUIntN(streamId, self.storageAreaIndex, ObjectStorage.STORAGE_SEND_NUM_BITS)

    local attributes = self.attributes
    local fillLevel = attributes.fillLevel or 0

    streamWriteString(streamId, NetworkUtil.convertToNetworkFilename(attributes.xmlFilename or ""))
    streamWriteFloat32(streamId, fillLevel)
    streamWriteFloat32(streamId, attributes.capacity or fillLevel)
end

function ObjectStorageAddObjectEvent:run(connection)
    if connection:getIsServer() and self.object ~= nil then
        self.object:addToStorage(self.object.indexedStorageAreas[self.storageAreaIndex], self.attributes)
    end
end
