--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 02.01.2022
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ObjectStorageSetObjectTypeEvent = {}

local ObjectStorageSetObjectTypeEvent_mt = Class(ObjectStorageSetObjectTypeEvent, Event)
InitEventClass(ObjectStorageSetObjectTypeEvent, "ObjectStorageSetObjectTypeEvent")

function ObjectStorageSetObjectTypeEvent.emptyNew()
    local self = Event.new(ObjectStorageSetObjectTypeEvent_mt)

    return self
end

function ObjectStorageSetObjectTypeEvent.new(object, storageAreaIndex, objectTypeIndex, fillTypeIndex)
    local self = ObjectStorageSetObjectTypeEvent.emptyNew()

    self.object = object
    self.storageAreaIndex = storageAreaIndex
    self.objectTypeIndex = objectTypeIndex
    self.fillTypeIndex = fillTypeIndex

    return self
end

function ObjectStorageSetObjectTypeEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.storageAreaIndex = streamReadUIntN(streamId, ObjectStorage.STORAGE_SEND_NUM_BITS)
    self.objectTypeIndex = streamReadUIntN(streamId, ObjectStorage.TYPE_SEND_NUM_BITS)
    self.fillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)

    self:run(connection)
end

function ObjectStorageSetObjectTypeEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUIntN(streamId, self.storageAreaIndex, ObjectStorage.STORAGE_SEND_NUM_BITS)
    streamWriteUIntN(streamId, self.objectTypeIndex, ObjectStorage.TYPE_SEND_NUM_BITS)
    streamWriteUIntN(streamId, self.fillTypeIndex, FillTypeManager.SEND_NUM_BITS)
end

function ObjectStorageSetObjectTypeEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.object)
    end

    if self.object ~= nil then
        self.object:setStorageObjectType(self.storageAreaIndex, self.objectTypeIndex, self.fillTypeIndex, true)

        g_messageCenter:publishDelayed("OBJECT_STORAGE_UPDATE_GUI", self.object)
    end
end

function ObjectStorageSetObjectTypeEvent.sendEvent(object, storageAreaIndex, objectTypeIndex, fillTypeIndex, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(ObjectStorageSetObjectTypeEvent.new(object, storageAreaIndex, objectTypeIndex, fillTypeIndex), nil, nil, object)
        else
            g_client:getServerConnection():sendEvent(ObjectStorageSetObjectTypeEvent.new(object, storageAreaIndex, objectTypeIndex, fillTypeIndex))
        end
    end
end




