--[[
Copyright (C) GtX (Andy), 2022

Author: GtX | Andy
Date: 02.01.2022
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy
Copying or removing any part of this code for external use without written permission from GtX | Andy is prohibited.

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
Das Kopieren oder Entfernen irgendeines Teils dieses Codes zur externen Verwendung ohne schriftliche Genehmigung von GtX | Andy ist verboten.
]]

ObjectStorageSpawnerStatusEvent = {}

local ObjectStorageSpawnerStatusEvent_mt = Class(ObjectStorageSpawnerStatusEvent, Event)
InitEventClass(ObjectStorageSpawnerStatusEvent, "ObjectStorageSpawnerStatusEvent")

function ObjectStorageSpawnerStatusEvent.emptyNew()
    local self = Event.new(ObjectStorageSpawnerStatusEvent_mt)

    return self
end

function ObjectStorageSpawnerStatusEvent.new(object, statusCode)
    local self = ObjectStorageSpawnerStatusEvent.emptyNew()

    self.object = object
    self.statusCode = statusCode

    return self
end

function ObjectStorageSpawnerStatusEvent:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId)
    self.statusCode = streamReadUIntN(streamId, 3)

    self:run(connection)
end

function ObjectStorageSpawnerStatusEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object)
    streamWriteUIntN(streamId, self.statusCode, 3)
end

function ObjectStorageSpawnerStatusEvent:run(connection)
    if self.object ~= nil then
        g_messageCenter:publishDelayed("OBJECT_STORAGE_SPAWNER_STATUS", self.object, self.statusCode)
    end
end