--[[
Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 05.10.2019
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Free for use in mods (FS22 Only) - no permission needed.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy

Frei verwendbar (Nur LS22) - keine erlaubnis nötig
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
]]


PressureWasherVehiclePumpEvent = {}

local PressureWasherVehiclePumpEvent_mt = Class(PressureWasherVehiclePumpEvent, Event)
InitEventClass(PressureWasherVehiclePumpEvent, "PressureWasherVehiclePumpEvent")

function PressureWasherVehiclePumpEvent.emptyNew()
    local self = Event.new(PressureWasherVehiclePumpEvent_mt)
    return self
end

function PressureWasherVehiclePumpEvent.new(vehicle, workMultiplier)
    local self = PressureWasherVehiclePumpEvent.emptyNew()

    self.vehicle = vehicle
    self.workMultiplier = workMultiplier

    return self
end

function PressureWasherVehiclePumpEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.workMultiplier = streamReadUInt8(streamId) / 10

    self:run(connection)
end

function PressureWasherVehiclePumpEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteUInt8(streamId, self.workMultiplier * 10)
end

function PressureWasherVehiclePumpEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end

    if self.vehicle ~= nil and self.vehicle.adjustPumpWorkMultiplier ~= nil then
        self.vehicle:adjustPumpWorkMultiplier(self.workMultiplier, false)
    end
end
