--[[
Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 05.10.2019
Revision: FS22-01

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Free for use in mods (FS22 Only) - no permission needed.
No modifications may be made to this script, including conversion to other game versions without written permission from GtX | Andy

Frei verwendbar (Nur LS22) - keine erlaubnis nötig
Ohne schriftliche Genehmigung von GtX | Andy dürfen keine Änderungen an diesem Skript vorgenommen werden, einschließlich der Konvertierung in andere Spielversionen
]]


PressureWasherVehicleStateEvent = {}

local PressureWasherVehicleStateEvent_mt = Class(PressureWasherVehicleStateEvent, Event)
InitEventClass(PressureWasherVehicleStateEvent, "PressureWasherVehicleStateEvent")

function PressureWasherVehicleStateEvent.emptyNew()
    local self = Event.new(PressureWasherVehicleStateEvent_mt)
    return self
end

function PressureWasherVehicleStateEvent.new(vehicle, state, player)
    local self = PressureWasherVehicleStateEvent.emptyNew()

    self.vehicle = vehicle
    self.state = state
    self.player = player

    return self
end

function PressureWasherVehicleStateEvent:readStream(streamId, connection)
    self.vehicle = NetworkUtil.readNodeObject(streamId)
    self.state = streamReadUIntN(streamId, 3)

    if self.state == PressureWasherVehicle.STATE_ACTIVE then
        self.player = NetworkUtil.readNodeObject(streamId)
    end

    self:run(connection)
end

function PressureWasherVehicleStateEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.vehicle)
    streamWriteUIntN(streamId, self.state, 3)

    if self.state == PressureWasherVehicle.STATE_ACTIVE then
        NetworkUtil.writeNodeObject(streamId, self.player)
    end
end

function PressureWasherVehicleStateEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, false, connection, self.vehicle)
    end

    self.vehicle:setPressureWasherState(self.state, self.player, true)
end

function PressureWasherVehicleStateEvent.sendEvent(vehicle, state, player, noEventSend)
    if noEventSend == nil or noEventSend == false then
        if g_server ~= nil then
            g_server:broadcastEvent(PressureWasherVehicleStateEvent.new(vehicle, state, player), nil, nil, vehicle)
        else
            g_client:getServerConnection():sendEvent(PressureWasherVehicleStateEvent.new(vehicle, state, player))
        end
    end
end
