
Unimog = {}

local _modDirectory = g_currentModDirectory

function Unimog.prerequisitesPresent(specializations)
    return true
end

function Unimog.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onStartMotor", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onStopMotor", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onTurnLightStateChanged", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onGearChanged", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onPostAttachImplement", Unimog)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdateTick", Unimog)
end

function Unimog:onPreLoad(savegame)
    local configurationId = Utils.getNoNil(self.configurations["design3"], 0)
    local configurationId4 = Utils.getNoNil(self.configurations["design4"], 0)

    -- Change the standard horn sound to airhorn sound
    if configurationId == 4 or configurationId == 5 or configurationId == 6 or configurationId == 7 then
        removeXMLProperty(self.externalSoundsFile.handle, "sounds.honk.sound#file")
        setXMLString(self.externalSoundsFile.handle, "sounds.honk.sound#file", "sounds/u1600_horn_loop.ogg")
    end

    -- Move license plate, if elongatet (rechteckiges Nummernschild am Khlergrill (US-Map), lngliches Nummernschild auf die Haube)
    local platePreferedType = LicensePlateManager.PLATE_TYPE["ELONGATED"]
    local plateData = g_licensePlateManager:getLicensePlate(platePreferedType, true)
    if plateData ~= nil then
        if plateData.rawHeight ~= nil then
            if plateData.rawHeight < 0.111 then
                local nodeNameString
                for i=0, 0 do    -- for now only front number plate
                    nodeNameString = getXMLString(self.xmlFile.handle, "vehicle.licensePlates.licensePlate("..i..")#nodeEU")
                    if nodeNameString ~= nil then
                        removeXMLProperty(self.xmlFile.handle, "vehicle.licensePlates.licensePlate("..i..")#node")
                        setXMLString(self.xmlFile.handle, "vehicle.licensePlates.licensePlate("..i..")#node", nodeNameString)
                        if configurationId4 == 1 or configurationId4 == 3 then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.licensePlates.licensePlate("..i..")#frame")
                            setXMLString(self.xmlFile.handle, "vehicle.licensePlates.licensePlate("..i..")#frame", "false")
                        end
                        if configurationId4 == 7 then
                            removeXMLProperty(self.xmlFile.handle, "vehicle.licensePlates.licensePlate("..i..")#preferedType")
                            setXMLString(self.xmlFile.handle, "vehicle.licensePlates.licensePlate("..i..")#preferedType", "SQUARISH")
                        end
                    end
                end
            end
        end
    end
    
end

function Unimog:onLoad(savegame)
    self.detachImplement = Utils.appendedFunction(AttacherJoints.detachImplement, Unimog.detachImplement)

    self.trailerTurnWarningLightNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.trailerTurnWarningLight#node"), self.i3dMappings)
    self.trailer2TurnWarningLightNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.trailer2TurnWarningLight#node"), self.i3dMappings)

    self.ptoWarningLightNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.ptoWarningLight#node"), self.i3dMappings)
    self.tippingWarningLightNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.tippingWarningLight#node"), self.i3dMappings)
    setShaderParameter(self.ptoWarningLightNode, "lightControl", 0, 0, 0, 0, false)
    setShaderParameter(self.tippingWarningLightNode, "lightControl", 0, 0, 0, 0, false)
    self.isPtoWarningLightOn = false
    self.isTippingWarningLightOn = false

    self.handbrakeWarningLightNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.handbrakeWarningLight#node"), self.i3dMappings)
    self.differentialWarningLightNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.differentialWarningLight#node"), self.i3dMappings)
    self.fourWheelDriveWarningLightNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.fourWheelDriveWarningLight#node"), self.i3dMappings)
    
    self.gearLamp1 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.gearLamp1#node"), self.i3dMappings)
    self.gearLamp2 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.gearLamp2#node"), self.i3dMappings)
    self.gearLamp3 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.gearLamp3#node"), self.i3dMappings)
    self.gearLamp4 = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.gearLamp4#node"), self.i3dMappings)
    setShaderParameter(self.gearLamp1, "lightControl", 0, 0, 0, 0, false)
    setShaderParameter(self.gearLamp2, "lightControl", 0, 0, 0, 0, false)
    setShaderParameter(self.gearLamp3, "lightControl", 0, 0, 0, 0, false)
    setShaderParameter(self.gearLamp4, "lightControl", 0, 0, 0, 0, false)

    local forestFrameNode = I3DUtil.indexToObject(self.components, getXMLString(self.xmlFile.handle, "vehicle.unimog.forestFrame#node"), self.i3dMappings)
    local configurationId4 = Utils.getNoNil(self.configurations["design4"], 0)
    if configurationId4 == 5 then
        I3DUtil.setShaderParameterRec(forestFrameNode, "colorMat0", 0.45, 0.033, 0.038, 6)  -- Red for Tajfun forestry winch
    elseif configurationId4 == 6 then
        I3DUtil.setShaderParameterRec(forestFrameNode, "colorMat0", 0.029, 0.029, 0.029, 6) -- Black frame / schwarzer Bgel
    end

    self.gearLampState = 0
    self.gearLampStateBackup = 0
    self.turnLightAttachments = 0  -- spter wieder rausnehmen?
end

function Unimog:onPostLoad(savegame)
    local configurationId = Utils.getNoNil(self.configurations["tireSound"], 0)
    if configurationId > 1 then  -- turns of the Unimog tire sound if tireSound script is activated
        self.spec_motorized.samples.retarder.indoorAttributes.volume = 0
        self.spec_motorized.samples.retarder.outdoorAttributes.volume = 0
    end
end

function Unimog:onStartMotor()
    if self.gearLampState < 2 then
        setShaderParameter(self.gearLamp1, "lightControl", 2.5, 0, 0, 0, false)
        setShaderParameter(self.gearLamp2, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.gearLamp3, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.gearLamp4, "lightControl", 0, 0, 0, 0, false)
    elseif self.gearLampState == 2 then
        setShaderParameter(self.gearLamp1, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.gearLamp2, "lightControl", 2.5, 0, 0, 0, false)
        setShaderParameter(self.gearLamp3, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.gearLamp4, "lightControl", 0, 0, 0, 0, false)
    elseif self.gearLampState == 3 then
        setShaderParameter(self.gearLamp1, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.gearLamp2, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.gearLamp3, "lightControl", 2.5, 0, 0, 0, false)
        setShaderParameter(self.gearLamp4, "lightControl", 0, 0, 0, 0, false)
    elseif self.gearLampState == 4 then
        setShaderParameter(self.gearLamp1, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.gearLamp2, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.gearLamp3, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.gearLamp4, "lightControl", 2.5, 0, 0, 0, false)
    end
end

function Unimog:onStopMotor()
    setShaderParameter(self.gearLamp1, "lightControl", 0, 0, 0, 0, false)
    setShaderParameter(self.gearLamp2, "lightControl", 0, 0, 0, 0, false)
    setShaderParameter(self.gearLamp3, "lightControl", 0, 0, 0, 0, false)
    setShaderParameter(self.gearLamp4, "lightControl", 0, 0, 0, 0, false)
    setShaderParameter(self.ptoWarningLightNode, "lightControl", 0, 0, 0, 0, false)
    setShaderParameter(self.tippingWarningLightNode, "lightControl", 0, 0, 0, 0, false)
    self.isPtoWarningLightOn = false
    self.isTippingWarningLightOn = false
end

function Unimog:onTurnLightStateChanged(state)

    self.turnLightAttachments = 0
    if state == 0 then
        setShaderParameter(self.trailerTurnWarningLightNode, "lightControl", 0, 0, 0, 0, false)
        setShaderParameter(self.trailer2TurnWarningLightNode, "lightControl", 0, 0, 0, 0, false)
    else
        local turnLightAttachments = 0

        for _, implement in pairs(self:getAttachedImplements()) do
            if implement.object ~= nil then
                local vehicle = implement.object
                if vehicle.spec_lights ~= nil then
                    if vehicle.spec_lights.realLights ~= nil then
                        if vehicle.spec_lights.realLights.high ~= nil then
                            if vehicle.spec_lights.realLights.high.turnLightsLeft ~= nil then
                                if vehicle.spec_lights.realLights.high.turnLightsLeft[1] ~= nil then
                                    turnLightAttachments = turnLightAttachments + 1
                                end
                            end
                        end
                    end
                end
            end
        end

        if turnLightAttachments > 0 then
            setShaderParameter(self.trailerTurnWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
            if turnLightAttachments > 1 then
                setShaderParameter(self.trailer2TurnWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
            end
        end
        self.turnLightAttachments = turnLightAttachments
    end
end

function Unimog:onPostAttachImplement(attacherVehicle, inputJointDescIndex, jointDescIndex)
    if self.spec_lights.turnLightState > 0 then
        local turnLightAttachments = 0
        for _, implement in pairs(self:getAttachedImplements()) do
            if implement.object ~= nil then
                local vehicle = implement.object
                if vehicle.spec_lights ~= nil then
                    if vehicle.spec_lights.realLights ~= nil then
                        if vehicle.spec_lights.realLights.high ~= nil then
                            if vehicle.spec_lights.realLights.high.turnLightsLeft ~= nil then
                                if vehicle.spec_lights.realLights.high.turnLightsLeft[1] ~= nil then
                                    turnLightAttachments = turnLightAttachments + 1
                                end
                            end
                        end
                    end
                end
            end
        end
        if turnLightAttachments > self.turnLightAttachments then
            if turnLightAttachments == 1 then
                setShaderParameter(self.trailerTurnWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
            else
                setShaderParameter(self.trailer2TurnWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
            end
        end
        self.turnLightAttachments = turnLightAttachments
    end
end

function Unimog:detachImplement(implementIndex, noEventSend)
    if self.spec_lights.turnLightState > 0 then
        local turnLightAttachments = 0
        for _, implement in pairs(self:getAttachedImplements()) do
            if implement.object ~= nil then
                local vehicle = implement.object
                if vehicle.spec_lights ~= nil then
                    if vehicle.spec_lights.realLights ~= nil then
                        if vehicle.spec_lights.realLights.high ~= nil then
                            if vehicle.spec_lights.realLights.high.turnLightsLeft ~= nil then
                                if vehicle.spec_lights.realLights.high.turnLightsLeft[1] ~= nil then
                                    turnLightAttachments = turnLightAttachments + 1
                                end
                            end
                        end
                    end
                end
            end
        end
        --print(turnLightAttachments)
        --print(self.turnLightAttachments)
        if turnLightAttachments < self.turnLightAttachments then
            if turnLightAttachments == 0 then
                setShaderParameter(self.trailerTurnWarningLightNode, "lightControl", 0, 0, 0, 0, false)
            elseif turnLightAttachments == 1 then
                setShaderParameter(self.trailer2TurnWarningLightNode, "lightControl", 0, 0, 0, 0, false)
            end
        end
        self.turnLightAttachments = turnLightAttachments
    end
end

function Unimog:onGearChanged(gear, targetGear, changeTime)

    if gear == targetGear then
        self.gearLampState = math.ceil(targetGear / 2)
    end
    
    if self.gearLampStateBackup ~= self.gearLampState and self.spec_motorized.isMotorStarted then
        if self.gearLampState < 2 then
            setShaderParameter(self.gearLamp1, "lightControl", 2.5, 0, 0, 0, false)
            setShaderParameter(self.gearLamp2, "lightControl", 0, 0, 0, 0, false)
            setShaderParameter(self.gearLamp3, "lightControl", 0, 0, 0, 0, false)
            setShaderParameter(self.gearLamp4, "lightControl", 0, 0, 0, 0, false)
        elseif self.gearLampState == 2 then
            setShaderParameter(self.gearLamp1, "lightControl", 0, 0, 0, 0, false)
            setShaderParameter(self.gearLamp2, "lightControl", 2.5, 0, 0, 0, false)
            setShaderParameter(self.gearLamp3, "lightControl", 0, 0, 0, 0, false)
            setShaderParameter(self.gearLamp4, "lightControl", 0, 0, 0, 0, false)
        elseif self.gearLampState == 3 then
            setShaderParameter(self.gearLamp1, "lightControl", 0, 0, 0, 0, false)
            setShaderParameter(self.gearLamp2, "lightControl", 0, 0, 0, 0, false)
            setShaderParameter(self.gearLamp3, "lightControl", 2.5, 0, 0, 0, false)
            setShaderParameter(self.gearLamp4, "lightControl", 0, 0, 0, 0, false)
        elseif self.gearLampState == 4 then
            setShaderParameter(self.gearLamp1, "lightControl", 0, 0, 0, 0, false)
            setShaderParameter(self.gearLamp2, "lightControl", 0, 0, 0, 0, false)
            setShaderParameter(self.gearLamp3, "lightControl", 0, 0, 0, 0, false)
            setShaderParameter(self.gearLamp4, "lightControl", 2.5, 0, 0, 0, false)
        end
    end
    self.gearLampStateBackup = self.gearLampState
    
end

function Unimog:onUpdateTick(dt)

    if self.spec_motorized.isMotorStarted then

        local attachedObjectIsTurnedOn = false
        local isTipping = false
        for _, implement in pairs(self:getAttachedImplements()) do
            if implement.object ~= nil then
                if implement.object.getIsTurnedOn ~= nil then
                    if implement.object:getIsTurnedOn() then
                        attachedObjectIsTurnedOn = true
                    end
                end
                if implement.object.getTipState ~= nil then
                    if implement.object:getTipState() > 0 then
                        isTipping = true
                    end
                end
            end
        end
        if attachedObjectIsTurnedOn then
            if self.isPtoWarningLightOn == false then
                setShaderParameter(self.ptoWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
                self.isPtoWarningLightOn = true
            end
        else
            if self.isPtoWarningLightOn == true then
                setShaderParameter(self.ptoWarningLightNode, "lightControl", 0, 0, 0, 0, false)
                self.isPtoWarningLightOn = false
            end
        end

        if isTipping == false then
            if self.spec_trailer.tipState > 0 then
                isTipping = true
            end
        end
 
        -- local intensity, _, _, _ = getShaderParameter(self.tippingWarningLightNode, "lightControl")
        -- renderText(0.66, 0.16, 0.035, tostring(isTipping))
        -- if getWorldRotation(self.unimogVisNode) == getWorldRotation(self.tankVisNode) then
        if isTipping == false then
          --  if self.isTippingWarningLightOn == true then
                setShaderParameter(self.tippingWarningLightNode, "lightControl", 0, 0, 0, 0, false)
                self.isTippingWarningLightOn = false
          --  end
        else
          --  if self.isTippingWarningLightOn == false then
                setShaderParameter(self.tippingWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
                self.isTippingWarningLightOn = true
          --  end
        end

        local handbrakeVCA = false
        local differentialVCA = false
        local fourWheelDriveVCA = false
        if self.spec_vca ~= nil then
            if self.spec_vca.handbrake ~= nil and self.spec_vca.handbrake == true then
                handbrakeVCA = true
            end
            if self.spec_vca.diffManual ~= nil and self.spec_vca.diffManual == true then
                if self.spec_vca.diffLockFront ~= nil and self.spec_vca.diffLockFront == true then
                    differentialVCA = true
                end
                if self.spec_vca.diffLockBack ~= nil and self.spec_vca.diffLockBack == true then
                    differentialVCA = true
                end
                if self.spec_vca.diffLockAWD ~= nil and self.spec_vca.diffLockAWD == true then
                    fourWheelDriveVCA = true
                end
            end    
        end

        local handbrakeEV = false
        local differentialEV = false
        local fourWheelDriveEV = false  -- EV = Enhance Vehicle
        if self.vData ~= nil and self.vData.is ~= nil and self.vData.is[13] ~= nil then
            if self.vData.is[13] == true then
                handbrakeEV = true
            end
            if self.vData.is[1] == true or self.vData.is[2] == true then
                differentialEV = true
            end
            if self.vData.is[3] == 1 then
                fourWheelDriveEV = true
            end
        end
        
        if handbrakeVCA == true or handbrakeEV == true then
            setShaderParameter(self.handbrakeWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
        else
            local intensity, _, _, _ = getShaderParameter(self.handbrakeWarningLightNode, "lightControl")
            if intensity > 0 then
                setShaderParameter(self.handbrakeWarningLightNode, "lightControl", 0, 0, 0, 0, false)
            end
        end
        if differentialVCA == true or differentialEV == true then
            setShaderParameter(self.differentialWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
        else
            local intensity, _, _, _ = getShaderParameter(self.differentialWarningLightNode, "lightControl")
            if intensity > 0 then
                setShaderParameter(self.differentialWarningLightNode, "lightControl", 0, 0, 0, 0, false)
            end
        end
        if fourWheelDriveVCA == true or fourWheelDriveEV == true then
            setShaderParameter(self.fourWheelDriveWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
        else
            local intensity, _, _, _ = getShaderParameter(self.fourWheelDriveWarningLightNode, "lightControl")
            if intensity > 0 then
                setShaderParameter(self.fourWheelDriveWarningLightNode, "lightControl", 0, 0, 0, 0, false)
            end
        end
        
    end

    -- spter wieder raus
    if self.turnLightAttachments > 0 then
        if self.turnLightAttachments == 1 then
            setShaderParameter(self.trailerTurnWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
        else
            setShaderParameter(self.trailerTurnWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
            setShaderParameter(self.trailer2TurnWarningLightNode, "lightControl", 1.1, 0, 0, 0, false)
        end
    end
end
