--[[
    Author: PeterAH (Modding-Welt)
    Mod name: Air Hose Connect Sound
    Version: 1.1.0.0
    Date: April 2022
    Contact: https://www.modding-welt.com
    Discord: [MW] PeterAH#5807
]]


if g_specializationManager:getSpecializationByName("airHoseConnectSound") == nil then
    g_specializationManager:addSpecialization('airHoseConnectSound', 'airHoseConnectSound', Utils.getFilename('airHoseConnectSound.lua', g_currentModDirectory), nil)
end

for vehicleTypeName, vehicleType in pairs(g_vehicleTypeManager.types) do 
    if vehicleType == nil then
    elseif SpecializationUtil.hasSpecialization(airHoseConnectSound, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Motorized, vehicleType.specializations) then
    elseif SpecializationUtil.hasSpecialization(Drivable, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Wheels, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(Attachable, vehicleType.specializations) then
    elseif not SpecializationUtil.hasSpecialization(ConnectionHoses, vehicleType.specializations) then
    elseif vehicleTypeName == 'trainTimberTrailer' then
    elseif vehicleTypeName == 'trainTrailer' then
    else
        g_vehicleTypeManager:addSpecialization(vehicleTypeName, 'airHoseConnectSound')
    end 
end
