--[[
	AutoTurnOffTurnLights.lua
	
	Author: 	Ifko[nator]
	Date:		18.11.2021
	Version:	3.0 
	
	History:	v1.0 @31.10.2016 - initial implementation in FS 17
				---------------------------------------------------
				v2.0 @30.11.2018 - convert to FS 19
				---------------------------------------------------
				v3.0 @18.11.2021 - convert to FS 22
]]


AutoTurnOffTurnLights = {};

function AutoTurnOffTurnLights.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function AutoTurnOffTurnLights.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",
		"onUpdate"
	};
	
	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, AutoTurnOffTurnLights);
	end;
end;

function AutoTurnOffTurnLights:onLoad(savegame)
	local specDrivable = self.spec_drivable;
	
	specDrivable.hasSteerToTurnLeftDirection = false;
	specDrivable.hasSteerToTurnRightDirection = false;
end;

function AutoTurnOffTurnLights:onUpdate(dt, isActiveForInput, isActiveForInputIngnoreSelection, isSelected)
	local specDrivable = self.spec_drivable;

	if self:getIsActive() and specDrivable ~= nil and specDrivable.steeringWheel ~= nil then
		local _, steeringRotY, _ = getRotation(specDrivable.steeringWheel.node);
		
		if specDrivable.hasSteerToTurnLeftDirection or specDrivable.hasSteerToTurnRightDirection then
			local allowAutoTurnOffTurnLights = false;
			
			if specDrivable.hasSteerToTurnLeftDirection then
				allowAutoTurnOffTurnLights = steeringRotY <= 0.001;
			elseif specDrivable.hasSteerToTurnRightDirection then
				allowAutoTurnOffTurnLights = steeringRotY >= -0.001;
			end;
			
			if allowAutoTurnOffTurnLights then
				self:setTurnLightState(Lights.TURNLIGHT_OFF);
				
				specDrivable.hasSteerToTurnLeftDirection = false;
				specDrivable.hasSteerToTurnRightDirection = false;
			end;
		elseif self.spec_lights.turnLightState == Lights.TURNLIGHT_LEFT then
			specDrivable.hasSteerToTurnLeftDirection = steeringRotY > 0.1;
		elseif self.spec_lights.turnLightState == Lights.TURNLIGHT_RIGHT then
			specDrivable.hasSteerToTurnRightDirection = steeringRotY < -0.1;
		end;
	end;
end;