ColorConfiguratorMultiOptionElement = {}

local ColorConfiguratorMultiOptionElement_mt = Class(ColorConfiguratorMultiOptionElement, MultiTextOptionElement)

function ColorConfiguratorMultiOptionElement.new(target, custom_mt)
	local self = MultiTextOptionElement.new(target, custom_mt or ColorConfiguratorMultiOptionElement_mt)

	self.wrapOnScroll = true

	return self
end

function ColorConfiguratorMultiOptionElement:loadFromXML(xmlFile, key)
	ColorConfiguratorMultiOptionElement:superClass().loadFromXML(self, xmlFile, key)

	self.wrapOnScroll = Utils.getNoNil(getXMLBool(xmlFile, key .. "#wrapOnScroll"), self.wrapOnScroll)
end

function ColorConfiguratorMultiOptionElement:loadProfile(profile, applyProfile)
	ColorConfiguratorMultiOptionElement:superClass().loadProfile(self, profile, applyProfile)

	self.wrapOnScroll = profile:getBool("wrapOnScroll", self.wrapOnScroll)
end

function ColorConfiguratorMultiOptionElement:mouseEvent(posX, posY, isDown, isUp, button, eventUsed)
	if self:getIsActive() then
		if ColorConfiguratorMultiOptionElement:superClass().mouseEvent(self, posX, posY, isDown, isUp, button, eventUsed) then
			eventUsed = true
		end

		if not eventUsed and isDown and GuiUtils.checkOverlayOverlap(posX, posY, self.absPosition[1], self.absPosition[2], self.absSize[1], self.absSize[2]) then
			if Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_UP) then
				if self.wrapOnScroll or (not self.wrapOnScroll and self.state > 1) then
					self:onLeftButtonClicked()
				end
			elseif Input.isMouseButtonPressed(Input.MOUSE_BUTTON_WHEEL_DOWN) then
				if self.wrapOnScroll or (not self.wrapOnScroll and self.state < #self.texts) then
					self:onRightButtonClicked()
				end
			end

			eventUsed = true
		end
	end

	return eventUsed
end