--
-- horseman
-- Makes it easier to keep your horses has been ridden and brushed
-- DisPlayBoy
--

horseman = {}
horseman.ridingCoef = 0.4
horseman.brushingCoef = 0.1
horseman.work = false

function horseman:loadMap()
	g_messageCenter:subscribe(MessageType.HOUR_CHANGED, self.hourChanged, self)
end

function horseman:hourChanged()
	if g_server ~= nil and g_currentMission.environment.currentHour == 23 then
		local paymentByOwner = {}
		local difficultyCoef = string.format("%.1f", math.sqrt(g_currentMission.missionInfo.economicDifficulty) * 1.02)
		local costCoef = string.format("%.2f", difficultyCoef / g_currentMission.environment.daysPerPeriod)
		for _, husbandry in pairs(g_currentMission.husbandrySystem.clusterHusbandries) do
			if husbandry.animalTypeName == "HORSE" then
				local farmId = husbandry.placeable.ownerFarmId
				if paymentByOwner[farmId] == nil then paymentByOwner[farmId] = 0; end
				for _, horse in pairs(husbandry.animalIdToCluster) do
					local fitnessCoef, paymentForHorse = 0, 0
					if horse.riding < 100 then
						fitnessCoef = 1 + (100 - horse.fitness) / 100
						paymentForHorse = paymentForHorse + (100 - horse.riding) * fitnessCoef * horseman.ridingCoef
						horse.dirt = horse.dirt + (100 - horse.riding)
						if horse.dirt > 100 then horse.dirt = 100; end
						horse.riding = 100
					end
					if horse.dirt > 0 then
						paymentForHorse = paymentForHorse + horse.dirt * horseman.brushingCoef
						horse.dirt = 0
					end
					paymentByOwner[farmId] = paymentByOwner[farmId] + math.ceil(paymentForHorse * costCoef)
					if paymentForHorse > 0 and horseman.work == false then horseman.work = true; end
				end
			end
		end
		if horseman.work == true then
			for farmId, paymentTotal in pairs(paymentByOwner) do
				if paymentTotal > 0 then
					g_currentMission:addMoney(-paymentTotal, farmId, MoneyType.AI, true, true)
				end
			end
		end
	end
end

addModEventListener(horseman)