PlaceableHoseSystem = {
	specEntryName = string.format("spec_%s.hoseSystemPlaceable", g_currentModName)
}

function PlaceableHoseSystem.prerequisitesPresent(specializations)
	return true
end

function PlaceableHoseSystem.registerFunctions(placeableType)
	SpecializationUtil.registerFunction(placeableType, "onVehicleLoaded", PlaceableHoseSystem.onVehicleLoaded)
	SpecializationUtil.registerFunction(placeableType, "onVehicleDelete", PlaceableHoseSystem.onVehicleDelete)
end

function PlaceableHoseSystem.registerOverwrittenFunctions(placeableType)
	SpecializationUtil.registerOverwrittenFunction(placeableType, "canBeSold", PlaceableHoseSystem.canBeSold)
end

function PlaceableHoseSystem.registerEventListeners(placeableType)
	SpecializationUtil.registerEventListener(placeableType, "onLoad", PlaceableHoseSystem)
	SpecializationUtil.registerEventListener(placeableType, "onDelete", PlaceableHoseSystem)
end

function PlaceableHoseSystem.registerXMLPaths(schema, basePath)
	schema:setXMLSpecializationType("hoseSystemPlaceable")
	schema:register(XMLValueType.STRING, "placeable.hoseSystemBridge#xmlFilename", "Vehicle xml filename")
	schema:register(XMLValueType.FLOAT, "placeable.hoseSystemBridge#heightOffset", "Vehicle height offset")
	schema:register(XMLValueType.FLOAT, "placeable.hoseSystemBridge#yRotation", "Vehicle Y rotation offset")
	schema:setXMLSpecializationType()
end

function PlaceableHoseSystem:onLoad(savegame)
	if self.isServer then
		local filename = self.xmlFile:getValue("placeable.hoseSystemBridge#xmlFilename")

		if filename ~= nil then
			local xmlFilename = Utils.getFilename(filename, self.baseDirectory)
			local posX, posY, posZ = getWorldTranslation(self.rootNode)
			local dx, _, dz = localDirectionToWorld(self.rootNode, 0, 0, 1)
			local rotY = MathUtil.getYRotationFromDirection(dx, dz)
			local heightOffset = self.xmlFile:getValue("placeable.hoseSystemBridge#heightOffset", 0)
			local yRotation = self.xmlFile:getValue("placeable.hoseSystemBridge#yRotation", 0)
			local location = {
				x = posX,
				y = posY + heightOffset,
				z = posZ,
				xRot = 0,
				yRot = rotY + math.rad(yRotation),
				zRot = 0
			}

			VehicleLoadingUtil.loadVehicle(xmlFilename, location, true, 0, Vehicle.PROPERTY_STATE_NONE, self:getOwnerFarmId(), nil, nil, self.onVehicleLoaded, self)
		end
	end
end

function PlaceableHoseSystem:onDelete()
	local spec = self[PlaceableHoseSystem.specEntryName]

	if spec.vehicle ~= nil then
		g_currentMission:removeVehicle(spec.vehicle)

		spec.vehicle = nil
	end
end

function PlaceableHoseSystem:canBeSold(superFunc)
	local spec = self[PlaceableHoseSystem.specEntryName]

	if spec.vehicle ~= nil and spec.vehicle:getIsActive() then
		return false, g_i18n:getText("shop_messageReturnVehicleInUse")
	end

	return superFunc(self)
end

function PlaceableHoseSystem:onVehicleLoaded(vehicle, vehicleLoadState, args)
	local spec = self[PlaceableHoseSystem.specEntryName]

	if vehicle ~= nil then
		vehicle.isVehicleSaved = false
		vehicle:addDeleteListener(self, "onVehicleDelete")

		spec.vehicle = vehicle
	end
end

function PlaceableHoseSystem:onVehicleDelete(vehicle)
	local spec = self[PlaceableHoseSystem.specEntryName]

	if spec.vehicle == vehicle then
		self:delete()

		spec.vehicle = nil
	end
end