-- author: DD ModPassion
-- copyright (C): DD ModPassion, All Rights Reserved
-- version: Farming Simulator 22
FillUnitAddon = {} local modDirectory = g_modsDirectory or "unknown" local modName = g_currentModName function FillUnitAddon.prerequisitesPresent(specializations) return SpecializationUtil.hasSpecialization(FillUnit, specializations) end function FillUnitAddon.registerOverwrittenFunctions(vehicleType) SpecializationUtil.registerOverwrittenFunction(vehicleType, "unloadFillUnits", FillUnitAddon.unloadFillUnits) end function FillUnitAddon:unloadFillUnits(ignoreWarning) if not self.isServer then g_client:getServerConnection():sendEvent(FillUnitUnloadEvent.new(self)) else local spec = self.spec_fillUnit if spec.unloadingFillUnitsRunning then return end local unloadingPlaces = spec.unloading local places = {} for _, unloading in ipairs(unloadingPlaces) do local node = unloading.node local ox, oy, oz = unpack(unloading.offset) local x, y, z = localToWorld(node, ox - unloading.width * 0.5, oy, oz) local place = { startZ = z, startY = y, startX = x } place.rotX, place.rotY, place.rotZ = getWorldRotation(node) place.dirX, place.dirY, place.dirZ = localDirectionToWorld(node, 1, 0, 0) place.dirPerpX, place.dirPerpY, place.dirPerpZ = localDirectionToWorld(node, 0, 0, 1) place.yOffset = 1 place.maxWidth = math.huge place.maxLength = math.huge place.maxHeight = math.huge place.width = unloading.width table.insert(places, place) end local usedPlaces = {} local success = true local availablePallets = {} local unloadingTasks = {} for k, fillUnit in ipairs(self:getFillUnits()) do local fillLevel = self:getFillUnitFillLevel(k) local fillTypeIndex = self:getFillUnitFillType(k) local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex) if fillUnit.canBeUnloaded and fillLevel > 0 and fillType.palletFilename ~= nil then local fillTypeName = string.lower(g_fillTypeManager:getFillTypeNameByIndex(self:getFillUnitFillType(k))) local palletFilename = Utils.getFilenameFromPath(fillType.palletFilename) if fillTypeName:contains("foilwrap") then palletFilename = string.format(modDirectory.."FS22_foilWrap_addon/xmlFilename/pallets/"..string.format(self.spec_foilWrapAddon.rollLength).."/"..palletFilename) Logging.devInfo("%s: unload fill units to pallet with roll length is: %s and palletFilename is: ", modName, self.spec_foilWrapAddon.rollLength) end if fillTypeName:contains("netwrap") then palletFilename = string.format(modDirectory.."FS22_netWrap_addon/xmlFilename/pallets/"..string.format(self.spec_netWrapAddon.rollLength).."/"..palletFilename) Logging.devInfo("%s: unload fill units to pallet with roll length is: %s and palletFilename is: ", modName, self.spec_netWrapAddon.rollLength) end if fillTypeName:contains("twine") then palletFilename = string.format(modDirectory.."FS22_twine_addon/xmlFilename/pallets/"..string.format(self.spec_twineAddon.rollLength).."/"..palletFilename) Logging.devInfo("%s: unload fill units to pallet with roll length is: %s and palletFilename is: ", modName, self.spec_twineAddon.rollLength) end if fileExists(palletFilename) then fillType.palletFilename = palletFilename Logging.devInfo(fillType.palletFilename) else Logging.devInfo(palletFilename) end table.insert(unloadingTasks, { fillUnitIndex = k, fillTypeIndex = fillTypeIndex, fillLevel = fillLevel, filename = fillType.palletFilename }) end end local function unloadNext() local task = unloadingTasks[1] if task ~= nil then for pallet, _ in pairs(availablePallets) do local fillUnitIndex = pallet:getFirstValidFillUnitToFill(task.fillTypeIndex) if fillUnitIndex ~= nil then local appliedDelta = pallet:addFillUnitFillLevel(self:getOwnerFarmId(), fillUnitIndex, task.fillLevel, task.fillTypeIndex, ToolType.UNDEFINED, nil) self:addFillUnitFillLevel(self:getOwnerFarmId(), task.fillUnitIndex, -appliedDelta, task.fillTypeIndex, ToolType.UNDEFINED, nil) task.fillLevel = task.fillLevel - appliedDelta if pallet:getFillUnitFreeCapacity(fillUnitIndex) <= 0 then availablePallets[pallet] = nil end end end if task.fillLevel > 0 then local function asyncCallback(_, vehicle, vehicleLoadState, arguments) if vehicleLoadState == VehicleLoadingUtil.VEHICLE_LOAD_OK then vehicle:emptyAllFillUnits(true) availablePallets[vehicle] = true unloadNext() end end local size = StoreItemUtil.getSizeValues(task.filename, "vehicle", 0, {}) local x, y, z, place, width, _ = PlacementUtil.getPlace(places, size, usedPlaces, true, true, true) if x == nil then success = false if (ignoreWarning == nil or not ignoreWarning) and not success then g_currentMission:addIngameNotification(FSBaseMission.INGAME_NOTIFICATION_INFO, spec.texts.unloadNoSpace) end return end PlacementUtil.markPlaceUsed(usedPlaces, place, width) local location = { x = x, y = y, z = z, yRot = place.rotY } VehicleLoadingUtil.loadVehicle(task.filename, location, true, 0, Vehicle.PROPERTY_STATE_OWNED, self:getOwnerFarmId(), nil, nil, asyncCallback, nil) else table.remove(unloadingTasks, 1) unloadNext() end end end unloadNext() end end