-- author: DD ModPassion
-- copyright (C): DD ModPassion, All Rights Reserved
-- version: Farming Simulator 22
NetWrapAddon = {SPEC_NAME = g_currentModName..".netWrapAddon"} local modDirectory = g_currentModDirectory or "unknown" local modName = g_currentModName function NetWrapAddon.initSpecialization() g_configurationManager:addConfigurationType("netWrapAddon", string.format(g_i18n:getText("name_netWrap").." Addon"), nil, nil, nil, nil, ConfigurationUtil.SELECTOR_MULTIOPTION) StoreItemUtil.getConfigurationsFromXML = Utils.overwrittenFunction(StoreItemUtil.getConfigurationsFromXML, getConfigurationsFromXML) local schema = Vehicle.xmlSchema schema:setXMLSpecializationType("NetWrapAddon") schema:register(XMLValueType.INT, "vehicle.baler.netWrapAddon#windings", "number of windings", 8) schema:register(XMLValueType.STRING, "vehicle.baler.netWrapAddon#storage", "storage configuration") schema:register(XMLValueType.INT, "vehicle.baler.netWrapAddon#configuration", "configuration index") schema:register(XMLValueType.NODE_INDEX, "vehicle.baler.netWrapAddon.baseNode(?)#node", "node to hide") schema:register(XMLValueType.STRING, "vehicle.baler.netWrapAddon.baseNode(?)#texture", "texture file") schema:register(XMLValueType.NODE_INDEX, "vehicle.baler.netWrapAddon.roll#node", "roll node") schema:register(XMLValueType.VECTOR_TRANS, "vehicle.baler.netWrapAddon.roll#translation", "translation roll") schema:register(XMLValueType.VECTOR_ROT, "vehicle.baler.netWrapAddon.roll#rotation", "rotation roll") schema:register(XMLValueType.VECTOR_SCALE, "vehicle.baler.netWrapAddon.roll#scale", "scale roll") schema:register(XMLValueType.STRING, "vehicle.baler.netWrapAddon.roll#texture", "texture file") schema:register(XMLValueType.NODE_INDEX, "vehicle.baler.netWrapAddon.scroll#node", "scroll node") schema:register(XMLValueType.VECTOR_TRANS, "vehicle.baler.netWrapAddon.scroll#translation", "translation scroll") schema:register(XMLValueType.VECTOR_ROT, "vehicle.baler.netWrapAddon.scroll#rotation", "rotation scroll") schema:register(XMLValueType.VECTOR_SCALE, "vehicle.baler.netWrapAddon.scroll#scale", "scale scroll") schema:register(XMLValueType.STRING, "vehicle.baler.netWrapAddon.scroll#texture", "texture file") schema:register(XMLValueType.NODE_INDEX, "vehicle.baler.netWrapAddon.storage(?)#node", "storage node") schema:register(XMLValueType.VECTOR_TRANS, "vehicle.baler.netWrapAddon.storage(?)#translation", "translation storage") schema:register(XMLValueType.VECTOR_ROT, "vehicle.baler.netWrapAddon.storage(?)#rotation", "rotation storage") schema:register(XMLValueType.VECTOR_SCALE, "vehicle.baler.netWrapAddon.storage(?)#scale", "scale storage") schema:setXMLSpecializationType() local schemaSavegame = Vehicle.xmlSchemaSavegame local baseKey = "vehicles.vehicle(?)."..NetWrapAddon.SPEC_NAME schemaSavegame:register(XMLValueType.FLOAT, baseKey.."#length", "Roll Length") schemaSavegame:register(XMLValueType.BOOL, baseKey.."#designColor", "Design color") end function NetWrapAddon.prerequisitesPresent(specializations) return SpecializationUtil.hasSpecialization(Baler, specializations) and SpecializationUtil.hasSpecialization(FillUnit, specializations) and SpecializationUtil.hasSpecialization(TurnOnVehicle, specializations) end function NetWrapAddon.registerEventListeners(vehicleType) SpecializationUtil.registerEventListener(vehicleType, "onLoad", NetWrapAddon) SpecializationUtil.registerEventListener(vehicleType, "onReadStream", NetWrapAddon) SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", NetWrapAddon) SpecializationUtil.registerEventListener(vehicleType, "onUpdate", NetWrapAddon) SpecializationUtil.registerEventListener(vehicleType, "onDraw", NetWrapAddon) SpecializationUtil.registerEventListener(vehicleType, "onChangedFillType", NetWrapAddon) SpecializationUtil.registerEventListener(vehicleType, "onFillUnitFillLevelChanged", NetWrapAddon) end function NetWrapAddon.registerOverwrittenFunctions(vehicleType) SpecializationUtil.registerOverwrittenFunction(vehicleType, "isUnloadingAllowed", NetWrapAddon.isUnloadingAllowed) SpecializationUtil.registerOverwrittenFunction(vehicleType, "getFillLevelInformation", NetWrapAddon.getFillLevelInformation) end function NetWrapAddon.registerFunctions(vehicleType) SpecializationUtil.registerFunction(vehicleType, "setNetWrapAddon", NetWrapAddon.setNetWrapAddon) end function NetWrapAddon:onLoad(savegame) self.spec_netWrapAddon = self["spec_"..NetWrapAddon.SPEC_NAME] local spec = self.spec_netWrapAddon spec.isRoundBale = self.xmlFile:getValue("vehicle.baler.baleTypes.baleType(0)#isRoundBale", false) if spec.isRoundBale then spec.balerFillUnit = 0 spec.netWrapFillUnit = 0 spec.storageFillUnit = 0 spec.rollStorage = 0 spec.netWrapRoll = {} spec.netWrapColor = { { fillTypeName = "black", brandColor = "SHARED_WRAP_BLACK" }, { fillTypeName = "claas", brandColor = "CLAAS_GREEN1" }, { fillTypeName = "fendt", brandColor = "FENDT_NEWGREEN1" }, { fillTypeName = "johndeere", brandColor = "JOHNDEERE_GREEN1" }, { fillTypeName = "krone", brandColor = "KRONE_GREEN1" }, { fillTypeName = "kuhn", brandColor = "KUHN_RED1" }, { fillTypeName = "kverneland", brandColor = "KVERNELAND_RED1" }, { fillTypeName = "masseyferguson", brandColor = "MASSEYFERGUSON_RED" }, { fillTypeName = "poettinger", brandColor = "POETTINGER_RED1" }, { fillTypeName = "vicon", brandColor = "VICON_RED1" }, { fillTypeName = "", brandColor = "SHARED_WRAP_WHITE" } } spec.designColor = false spec.rollLength = 2500 spec.rollColor = nil spec.showWarning = false spec.showAllowed = false spec.showPalletAllowed = false spec.fillingAllowed = false spec.baleNetWrapTime = 0 spec.baleNetWrapUse = 4 * 1000 spec.numberWindings = self.xmlFile:getValue("vehicle.baler.netWrapAddon#windings", 8) spec.baleNetWrapUsed = self.spec_baler.baleTypes[self.spec_baler.currentBaleTypeIndex].diameter * math.pi * spec.numberWindings for i = 1, #self.spec_fillUnit.fillUnits do if self:getFillUnitAllowsFillType(i, FillType.STRAW) and spec.balerFillUnit == 0 then spec.balerFillUnit = i elseif self:getFillUnitAllowsFillType(i, FillType.NETWRAP) and spec.netWrapFillUnit == 0 then spec.netWrapFillUnit = i elseif self:getFillUnitAllowsFillType(i, FillType.NETWRAP) and spec.storageFillUnit == 0 then spec.storageFillUnit = i end end self.configurations.netWrapAddon = Utils.getNoNil(self.configurations.netWrapAddon, 1) if self.configurations.netWrapAddon < 3 then NetWrapAddon.replaceCollisionMask(self.components[1].node, 2109442) for i = 1, #self.spec_fillUnit.fillUnits do if self:getFillUnitAllowsFillType(i, FillType.BALENET) then self:setFillUnitCapacity(i, 0) self.spec_strawHarvestRefillSupplies.isActive = false self.spec_strawHarvestRefillSupplies.hasCover = false end end local baseKey = string.format("vehicle.baler.netWrapAddon") local xmlFile = self.xmlFile local storeItem = g_storeManager:getItemByXMLFilename(self.configFileName) if not xmlFile:hasProperty(baseKey) then local xmlFilename = "$" if string.startsWith(storeItem.rawXMLFilename, xmlFilename) then xmlFilename = string.sub(storeItem.rawXMLFilename, 7, string.len(storeItem.rawXMLFilename)) else local modName, _ = Utils.getModNameAndBaseDirectory(storeItem.baseDir) if modName == "FS22_strawHarvestPack" then xmlFilename = modName.."/"..string.sub(storeItem.rawXMLFilename, 6, string.len(storeItem.rawXMLFilename)) else xmlFilename = modName.."/"..storeItem.rawXMLFilename end end xmlFile = XMLFile.loadIfExists("vehicleXml", Utils.getFilename("data/"..xmlFilename, modDirectory), Vehicle.xmlSchema) if xmlFile ~= nil then if not xmlFile:hasProperty(baseKey) then xmlFile = XMLFile.load("vehicleXml", Utils.getFilename("xmlFilename/mod.xml", modDirectory), Vehicle.xmlSchema) Logging.devInfo("%s: use the default xml file for vehicle settings of the mod => '%s' ", modName, xmlFilename) else Logging.devInfo("%s: use the xml file: 'data/%s' for vehicle settings of the mod ", modName, xmlFilename) end else xmlFile = XMLFile.load("vehicleXml", Utils.getFilename("xmlFilename/mod.xml", modDirectory), Vehicle.xmlSchema) Logging.devInfo("%s: use the default xml file for vehicle settings of the mod => '%s' ", modName, xmlFilename) end else xmlFilename = storeItem.rawXMLFilename Logging.devInfo("%s: use the xml file of the mod '%s' for vehicle settings ", modName, xmlFilename) end if spec.netWrapFillUnit == 0 then local fillUnitKey = string.format("vehicle.fillUnit.fillUnitConfigurations.fillUnitConfiguration(%d).fillUnits", 0) local i = 0 while true do local key = string.format("%s.fillUnit(%d)", fillUnitKey, i) if not xmlFile:hasProperty(key) then break end local entry = {} if self:loadFillUnitFromXML(xmlFile, key, entry, #self.spec_fillUnit.fillUnits + 1) then entry.canBeUnloaded = true table.insert(self.spec_fillUnit.fillUnits, entry) end i = i + 1 end self.spec_fillUnit.unloading = {} local entry = {} entry.node = self.rootNode entry.width = 14 entry.offset = {0, 0, 0} table.insert(self.spec_fillUnit.unloading, entry) for i = 1, #self.spec_fillUnit.fillUnits do if self:getFillUnitAllowsFillType(i, FillType.STRAW) and spec.balerFillUnit == 0 then spec.balerFillUnit = i elseif self:getFillUnitAllowsFillType(i, FillType.NETWRAP) and spec.netWrapFillUnit == 0 then spec.netWrapFillUnit = i elseif self:getFillUnitAllowsFillType(i, FillType.NETWRAP) and spec.storageFillUnit == 0 then spec.storageFillUnit = i end end end spec.rollLength = self:getFillUnitCapacity(spec.netWrapFillUnit) self.spec_fillUnit.fillTrigger.litersPerSecond = spec.rollLength * 1000 spec.numberWindings = xmlFile:getValue(baseKey.."#windings", 8) local i = 0 while true do local nodekey = string.format(baseKey..".baseNode(%d)", i) if not xmlFile:hasProperty(nodekey) then break end local node = xmlFile:getValue(nodekey.."#node", nil, self.components, self.i3dMappings) if node ~= nil and entityExists(node) then local texture = xmlFile:getValue(nodekey.."#texture") if texture ~= nil then texture = Utils.getFilename(texture, modDirectory) local materialId = getMaterial(node, 0) materialId = setMaterialDiffuseMapFromFile(materialId, texture, true, true, false) setMaterial(node, materialId, 0) else if getHasClassId(node, ClassIds.SHAPE) then setIsNonRenderable(node, true) end end end i = i + 1 end spec.netWrapRoll.materialNode = {} local node = xmlFile:getValue(baseKey..".roll#node", nil, self.components, self.i3dMappings) if node ~= nil and entityExists(node) then rollNode = createTransformGroup("roll") local translation = Utils.getNoNil(xmlFile:getValue(baseKey..".roll#translation", nil, self.components, self.i3dMappings), {0, 0, 0}) setTranslation(rollNode, unpack(translation)) local rotation = Utils.getNoNil(xmlFile:getValue(baseKey..".roll#rotation", nil, self.components, self.i3dMappings), {0, 0, 0}) setRotation(rollNode, unpack(rotation)) local scale = Utils.getNoNil(xmlFile:getValue(baseKey..".roll#scale", nil, self.components, self.i3dMappings), {1, 1, 1}) setScale(rollNode, unpack(scale)) link(node, rollNode) local i3dFilename = Utils.getFilename("filename/netWrapRoll.i3d", modDirectory) local i3dNode = g_i3DManager:loadSharedI3DFile(i3dFilename, false, false) local roll = I3DUtil.indexToObject(i3dNode, "0") link(rollNode, roll) spec.netWrapBalerRoll = roll setVisibility(spec.netWrapBalerRoll, false) spec.netWrapRollVolume = getChildAt(roll, 0) setScale(spec.netWrapRollVolume, 1, 0, 0) table.insert(spec.netWrapRoll.materialNode, spec.netWrapRollVolume) delete(i3dNode) if getHasClassId(node, ClassIds.SHAPE) then setIsNonRenderable(node, true) end local node = xmlFile:getValue(baseKey..".scroll#node", nil, self.components, self.i3dMappings) if node ~= nil and entityExists(node) then scrollNode = createTransformGroup("scroll") local translation = Utils.getNoNil(xmlFile:getValue(baseKey..".scroll#translation", nil, self.components, self.i3dMappings), {0, 0, 0}) setTranslation(scrollNode, unpack(translation)) local rotation = Utils.getNoNil(xmlFile:getValue(baseKey..".scroll#rotation", nil, self.components, self.i3dMappings), {0, 0, 0}) setRotation(scrollNode, unpack(rotation)) local scale = Utils.getNoNil(xmlFile:getValue(baseKey..".scroll#scale", nil, self.components, self.i3dMappings), {1, 1, 1}) setScale(scrollNode, unpack(scale)) link(node, scrollNode) local i3dFilenameBaler = Utils.getFilename(xmlFile:getValue(baseKey..".scroll#texture"), modDirectory) local i3dNodeBaler = g_i3DManager:loadSharedI3DFile(i3dFilenameBaler, false, false) local scroll = I3DUtil.indexToObject(i3dNodeBaler, "0") link(scrollNode, scroll) spec.balerScroll = scroll setVisibility(spec.balerScroll, false) table.insert(spec.netWrapRoll.materialNode, scroll) delete(i3dNodeBaler) end end spec.netWrapRoll.storageNode = {} local storageConfiguration = xmlFile:getValue(baseKey.."#storage") local storageConfigurationIndex = xmlFile:getValue(baseKey.."#configuration") if spec.storageFillUnit > 0 and storageConfiguration ~= nil then if self.configurations.netWrapAddon == 2 and self.configurations[storageConfiguration] == storageConfigurationIndex or self.configurations[storageConfiguration] == nil or storageConfigurationIndex == 0 then local i = 0 while true do local nodekey = string.format(baseKey..".storage(%d)", i) if not xmlFile:hasProperty(nodekey) then break end local node = xmlFile:getValue(nodekey.."#node", nil, self.components, self.i3dMappings) if node ~= nil and entityExists(node) then storageNode = createTransformGroup("roll") local translation = Utils.getNoNil(xmlFile:getValue(nodekey.."#translation", nil, self.components, self.i3dMappings), {0, 0, 0}) setTranslation(storageNode, unpack(translation)) local rotation = Utils.getNoNil(xmlFile:getValue(nodekey.."#rotation", nil, self.components, self.i3dMappings), {0, 0, 0}) setRotation(storageNode, unpack(rotation)) local scale = Utils.getNoNil(xmlFile:getValue(nodekey.."#scale", nil, self.components, self.i3dMappings), {1, 1, 1}) setScale(storageNode, unpack(scale)) link(node, storageNode) local i3dFilename = Utils.getFilename("filename/netWrapRoll.i3d", modDirectory) local i3dNode = g_i3DManager:loadSharedI3DFile(i3dFilename, false, false) local storage = I3DUtil.indexToObject(i3dNode, "0") link(storageNode, storage) table.insert(spec.netWrapRoll.storageNode, storage) if getHasClassId(node, ClassIds.SHAPE) then setIsNonRenderable(node, true) end delete(i3dNode) end i = i + 1 end spec.rollStorage = self:getFillUnitCapacity(spec.storageFillUnit) / spec.rollLength if #spec.netWrapRoll.storageNode > 0 then self:setFillUnitCapacity(spec.storageFillUnit, spec.rollLength * #spec.netWrapRoll.storageNode) spec.rollStorage = #spec.netWrapRoll.storageNode if self.spec_cover ~= nil and not self.spec_cover.hasCovers and xmlFile:hasProperty("vehicle.cover.coverConfigurations.coverConfiguration(0).cover(0)") then local cover = {} if self:loadCoverFromXML(xmlFile, "vehicle.cover.coverConfigurations.coverConfiguration(0).cover(0)", cover) then if self.spec_cover.fillUnitIndexToCovers[spec.storageFillUnit] == nil then self.spec_cover.fillUnitIndexToCovers[spec.storageFillUnit] = { cover } else table.insert(self.spec_cover.fillUnitIndexToCovers[spec.netWrapFillUnit], cover) table.insert(self.spec_cover.fillUnitIndexToCovers[spec.storageFillUnit], cover) end table.insert(self.spec_cover.covers, cover) cover.index = #self.spec_cover.covers end self.spec_cover.hasCovers = #self.spec_cover.covers > 0 if self.spec_cover.hasCovers then SpecializationUtil.registerEventListener(self, "onReadStream", Cover) SpecializationUtil.registerEventListener(self, "onWriteStream", Cover) SpecializationUtil.registerEventListener(self, "onUpdate", Cover) SpecializationUtil.registerEventListener(self, "onRegisterActionEvents", Cover) SpecializationUtil.registerEventListener(self, "onStartTipping", Cover) SpecializationUtil.registerEventListener(self, "onFillUnitTriggerChanged", Cover) SpecializationUtil.registerEventListener(self, "onRemovedFillUnitTrigger", Cover) end end for i = 1, #spec.netWrapRoll.storageNode do setVisibility(spec.netWrapRoll.storageNode[i], false) end else self:setFillUnitCapacity(spec.storageFillUnit, spec.rollLength * spec.rollStorage) end else local i = 0 while true do local nodekey = string.format(baseKey..".storage(%d)", i) if not xmlFile:hasProperty(nodekey) then break end local node = xmlFile:getValue(nodekey.."#node", nil, self.components, self.i3dMappings) if node ~= nil and entityExists(node) then if getHasClassId(node, ClassIds.SHAPE) then setIsNonRenderable(node, true) end end i = i + 1 end self:setFillUnitCapacity(spec.storageFillUnit, 0) spec.storageFillUnit = 0 end if self.configurations.netWrapAddon == 1 then self:setFillUnitCapacity(spec.storageFillUnit, 0) spec.storageFillUnit = 0 end end if xmlFile ~= self.xmlFile then xmlFile:delete() end if savegame ~= nil and not savegame.resetVehicles then local key = savegame.key.."."..NetWrapAddon.SPEC_NAME local designColor = savegame.xmlFile:getValue(key.."#designColor", spec.designColor) self:setNetWrapAddon(designColor, true) spec.rollLength = savegame.xmlFile:getValue(key.."#length", spec.rollLength) self:setFillUnitCapacity(spec.netWrapFillUnit, spec.rollLength) if spec.storageFillUnit > 0 then if #spec.netWrapRoll.storageNode > 0 then self:setFillUnitCapacity(spec.storageFillUnit, spec.rollLength * #spec.netWrapRoll.storageNode) spec.rollStorage = #spec.netWrapRoll.storageNode else self:setFillUnitCapacity(spec.storageFillUnit, spec.rollLength * spec.rollStorage) end end if savegame.xmlFile:hasProperty(savegame.key..".fillUnit") then local i = 0 while true do local key = string.format("%s.fillUnit.unit(%d)", savegame.key, i) if not savegame.xmlFile:hasProperty(key) then break end local fillTypeName = savegame.xmlFile:getValue(key.."#fillType") if fillTypeName:contains("NETWRAP") then spec.rollColor = string.lower(string.sub(fillTypeName, 0, -9)) end i = i + 1 end end end SpecializationUtil.removeEventListener(self, "onChangedFillType", Baler) else if spec.netWrapFillUnit > 0 then self:setFillUnitCapacity(spec.netWrapFillUnit, 0) end if spec.storageFillUnit > 0 then self:setFillUnitCapacity(spec.storageFillUnit, 0) end SpecializationUtil.removeEventListener(self, "onReadStream", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onWriteStream", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onUpdate", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onDraw", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onChangedFillType", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onFillUnitFillLevelChanged", NetWrapAddon) end else self.configurations.netWrapAddon = Utils.getNoNil(self.configurations.netWrapAddon, 3) SpecializationUtil.removeEventListener(self, "onUpdate", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onReadStream", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onWriteStream", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onDraw", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onChangedFillType", NetWrapAddon) SpecializationUtil.removeEventListener(self, "onFillUnitFillLevelChanged", NetWrapAddon) end end function NetWrapAddon:saveToXMLFile(xmlFile, key, usedModNames) if self.configurations.netWrapAddon < 3 then xmlFile:setValue(key.."#designColor", self.spec_netWrapAddon.designColor) xmlFile:setValue(key.."#length", self.spec_netWrapAddon.rollLength) end end function NetWrapAddon:onReadStream(streamId, connection) local designColor = streamReadBool(streamId) self:setNetWrapAddon(designColor, true) end function NetWrapAddon:onWriteStream(streamId, connection) local spec = self.spec_netWrapAddon streamWriteBool(streamId, spec.designColor) end function NetWrapAddon:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected) if self:getIsActive() or self:getIsAIActive() or self:getIsPowered() then local spec = self.spec_netWrapAddon if self:getFillUnitFillLevel(spec.netWrapFillUnit) > 0 then if spec.baleNetWrapTime <= spec.baleNetWrapUse and self:getFillUnitFillLevelPercentage(spec.balerFillUnit) > 0.9999 and self:getIsTurnedOn() then spec.baleNetWrapTime = spec.baleNetWrapTime + dt local fillDelta = dt * (spec.baleNetWrapUsed / spec.baleNetWrapUse) local stats = g_currentMission:farmStats(self:getOwnerFarmId()) stats:updateStats("netWrapUsage", fillDelta) if g_currentMission.missionInfo.helperBuyNetWrap and self:getIsAIActive() then local price = fillDelta * g_currentMission.economyManager:getCostPerLiter(FillType.NETWRAP, false) * 1.5 stats:updateStats("expenses", price) g_currentMission:addMoney(-price, farmId, MoneyType.PURCHASE_NETWRAP, true, true) else self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.netWrapFillUnit, -fillDelta, self:getFillUnitFillType(spec.netWrapFillUnit), ToolType.UNDEFINED, nil) end if spec.netWrapRollVolume ~= nil then local x, y, z = getRotation(spec.netWrapRollVolume) setRotation(spec.netWrapRollVolume, x + 0.05, y, z) if spec.balerScroll ~= nil then local _, y, _, _ = getShaderParameter(spec.balerScroll, "offsetUV") setShaderParameter(spec.balerScroll, "offsetUV", 0, y + 0.005, 0, 0, false) end end end if self:getFillUnitFillLevel(spec.balerFillUnit) <= 0 then if spec.baleNetWrapTime > 0 then spec.baleNetWrapTime = 0 end spec.baleNetWrapUsed = self.spec_baler.baleTypes[self.spec_baler.currentBaleTypeIndex].diameter * math.pi * spec.numberWindings if self:getFillUnitFillLevel(spec.netWrapFillUnit) < spec.baleNetWrapUsed and not self.spec_fillUnit.fillTrigger.isFilling then self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.netWrapFillUnit, -self:getFillUnitFillLevel(spec.netWrapFillUnit), self:getFillUnitFillType(spec.netWrapFillUnit), ToolType.UNDEFINED, nil) end end else if spec.storageFillUnit > 0 and self:getFillUnitFillLevel(spec.storageFillUnit) > 0 and not self.spec_fillUnit.fillTrigger.isFilling then if self:getFillUnitFillLevel(spec.storageFillUnit) > spec.rollLength then self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.storageFillUnit, -spec.rollLength, self:getFillUnitFillType(spec.storageFillUnit), ToolType.UNDEFINED, nil) self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.netWrapFillUnit, spec.rollLength, self:getFillUnitFillType(spec.storageFillUnit), ToolType.UNDEFINED, nil) else self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.netWrapFillUnit, self:getFillUnitFillLevel(spec.storageFillUnit), self:getFillUnitFillType(spec.storageFillUnit), ToolType.UNDEFINED, nil) self:addFillUnitFillLevel(self:getOwnerFarmId(), spec.storageFillUnit, -self:getFillUnitFillLevel(spec.storageFillUnit), self:getFillUnitFillType(spec.storageFillUnit), ToolType.UNDEFINED, nil) end else spec.fillingAllowed = true if self.isServer and self.spec_fillUnit.fillTrigger.isFilling and self.spec_fillUnit.fillTrigger.currentTrigger ~= nil and self.spec_fillUnit.fillTrigger.currentTrigger.sourceObject ~= nil then local pallet = self.spec_fillUnit.fillTrigger.currentTrigger.sourceObject if string.lower(g_fillTypeManager:getFillTypeNameByIndex(pallet:getFillUnitFillType(1))):contains("netwrap") then spec.rollLength = pallet:getFillUnitCapacity(1) / 10 self:setFillUnitCapacity(spec.netWrapFillUnit, spec.rollLength) if pallet.configurations.design == 1 then spec.designColor = true self:setNetWrapAddon(spec.designColor) else spec.designColor = false self:setNetWrapAddon(spec.designColor) end if spec.storageFillUnit > 0 then if #spec.netWrapRoll.storageNode > 0 then self:setFillUnitCapacity(spec.storageFillUnit, spec.rollLength * #spec.netWrapRoll.storageNode) spec.rollStorage = #spec.netWrapRoll.storageNode else self:setFillUnitCapacity(spec.storageFillUnit, spec.rollLength * spec.rollStorage) end end end end end end if spec.storageFillUnit > 0 then if self:getFillUnitFillLevelPercentage(spec.storageFillUnit) == 1 then spec.fillingAllowed = false end elseif self:getFillUnitFillLevelPercentage(spec.netWrapFillUnit) == 1 then spec.fillingAllowed = false end spec.showWarning = false if self:getFillUnitFillLevel(spec.netWrapFillUnit) <= 0 and self:getIsTurnedOn() then spec.showWarning = true self:setIsTurnedOn(false) end spec.showAllowed = false spec.showPalletAllowed = false if self.isServer and self.spec_fillUnit.fillTrigger.isFilling and self.spec_fillUnit.fillTrigger.currentTrigger ~= nil and self.spec_fillUnit.fillTrigger.currentTrigger.sourceObject ~= nil then local pallet = self.spec_fillUnit.fillTrigger.currentTrigger.sourceObject if string.lower(g_fillTypeManager:getFillTypeNameByIndex(pallet:getFillUnitFillType(1))):contains("netwrap") then if not spec.fillingAllowed then spec.showAllowed = true self:setFillUnitIsFilling(false) self:updateFillUnitTriggers() elseif self:getFillUnitFillLevel(spec.netWrapFillUnit) > 0 and (pallet:getFillUnitFillType(1) ~= self:getFillUnitFillType(spec.netWrapFillUnit) or pallet:getFillUnitCapacity(1) / 10 ~= spec.rollLength) then spec.showPalletAllowed = true self:setFillUnitIsFilling(false) self:updateFillUnitTriggers() end end end end end function NetWrapAddon:onDraw(isActiveForInput, isActiveForInputIgnoreSelection, isSelected) if self.isClient and isActiveForInputIgnoreSelection then local spec = self.spec_netWrapAddon if spec.storageFillUnit > 0 and self:getFillUnitFillLevel(spec.storageFillUnit) > 0 then g_currentMission:addExtraPrintText(g_i18n:getText("configuration_netWrapStored")..(" = ")..string.format("%.0f", self:getFillUnitFillLevel(spec.storageFillUnit) / self:getFillUnitCapacity(spec.storageFillUnit) * spec.rollStorage)..(" / ")..spec.rollStorage..(" ")..g_i18n:getText("unit_pieces")..(" ( ")..string.format("%.0f", self:getFillUnitFillLevel(spec.storageFillUnit))..("m / ")..self:getFillUnitCapacity(spec.storageFillUnit)..("m)"), modName) end if self:getFillUnitFillLevel(spec.netWrapFillUnit) <= 0 then g_currentMission:addExtraPrintText(g_i18n:getText("info_firstFillUnit", modName)) if spec.showWarning then g_currentMission:showBlinkingWarning(g_i18n:getText("info_firstFillUnit", modName), 2000) end end if spec.showAllowed then g_currentMission:showBlinkingWarning(g_i18n:getText("info_allowFillUnit", modName), 2000) end if spec.showPalletAllowed then g_currentMission:showBlinkingWarning(g_i18n:getText("info_allowFillPallet", modName), 4000) end end end function NetWrapAddon:onChangedFillType(fillUnitIndex, fillTypeIndex, oldFillTypeIndex) if fillTypeIndex ~= FillType.UNKNOWN and fillUnitIndex == self.spec_netWrapAddon.netWrapFillUnit then local spec = self.spec_netWrapAddon local netWrapColor = string.lower(string.sub(g_fillTypeManager:getFillTypeNameByIndex(self:getFillUnitFillType(spec.netWrapFillUnit)), 0, -9)) for i = 1, #spec.netWrapColor do if netWrapColor == spec.netWrapColor[i].fillTypeName then netWrapColor = g_brandColorManager:getBrandColorByName(spec.netWrapColor[i].brandColor) break end end for i = 1, #spec.netWrapRoll.materialNode do if self:getFillUnitFillLevel(spec.netWrapFillUnit) < 250 and not spec.designColor then setShaderParameter(spec.netWrapRoll.materialNode[i], "colorMat1", 0.85, 0.85, 0.85, 5, false) else setShaderParameter(spec.netWrapRoll.materialNode[i], "colorMat1", netWrapColor[1], netWrapColor[2], netWrapColor[3], netWrapColor[4], false) end end for i = 1, #spec.netWrapRoll.storageNode do setShaderParameter(getChildAt(spec.netWrapRoll.storageNode[i], 0), "colorMat1", netWrapColor[1], netWrapColor[2], netWrapColor[3], netWrapColor[4], false) end end local spec = self.spec_baler if fillUnitIndex == spec.fillUnitIndex or fillUnitIndex == spec.buffer.fillUnitIndex then local mainFillTypeIndex = self:getFillUnitFillType(spec.fillUnitIndex) if mainFillTypeIndex ~= FillType.UNKNOWN then fillTypeIndex = mainFillTypeIndex end if fillTypeIndex ~= FillType.UNKNOWN then local baleTypeDef = spec.baleTypes[spec.currentBaleTypeIndex] spec.currentBaleTypeDefinition = baleTypeDef if self:getFillUnitFillLevel(self.spec_netWrapAddon.netWrapFillUnit) < 250 and not self.spec_netWrapAddon.designColor then else local customEnvironment = string.lower(string.sub(g_fillTypeManager:getFillTypeNameByIndex(self:getFillUnitFillType(self.spec_netWrapAddon.netWrapFillUnit)), 0, -9)) if self.spec_netWrapAddon.rollColor ~= nil then customEnvironment = self.spec_netWrapAddon.rollColor self.spec_netWrapAddon.rollColor = nil end spec.currentBaleXMLFilename, spec.currentBaleIndex = g_baleManager:getBaleXMLFilename(fillTypeIndex, baleTypeDef.isRoundBale, baleTypeDef.width, baleTypeDef.height, baleTypeDef.length, baleTypeDef.diameter, customEnvironment) if spec.currentBaleXMLFilename ~= nil and string.lower(spec.currentBaleXMLFilename):contains(customEnvironment) then if customEnvironment == "" then customEnvironment = "white" end if not g_modIsLoaded.FS22_MaizePlus then Logging.devInfo("%s: create bale not for FS22_MaizePlus with color => '%s' and xmlFilename:", modName, customEnvironment) Logging.devInfo(spec.currentBaleXMLFilename) else Logging.devInfo("%s: create bale for FS22_MaizePlus with color => '%s' and xmlFilename:", modName, customEnvironment) Logging.devInfo(spec.currentBaleXMLFilename) end else if customEnvironment == "" then customEnvironment = "white" end Logging.info("%s: create bale with different color => '%s' Please contact the author of this mod. Thank you!", modName, customEnvironment) Logging.info(Utils.getNoNil(self.customEnvironment, "unknown")) end end if spec.currentBaleXMLFilename == nil then spec.currentBaleXMLFilename, spec.currentBaleIndex = g_baleManager:getBaleXMLFilename(fillTypeIndex, baleTypeDef.isRoundBale, baleTypeDef.width, baleTypeDef.height, baleTypeDef.length, baleTypeDef.diameter, self.customEnvironment) end local baleCapacity = g_baleManager:getBaleCapacityByBaleIndex(spec.currentBaleIndex, fillTypeIndex) if fillUnitIndex == spec.fillUnitIndex then self:setFillUnitCapacity(fillUnitIndex, baleCapacity, false) elseif spec.buffer.capacityPercentage ~= nil then self:setFillUnitCapacity(fillUnitIndex, baleCapacity * spec.buffer.capacityPercentage, false) end ObjectChangeUtil.setObjectChanges(baleTypeDef.changeObjects, true, self, self.setMovingToolDirty) if spec.currentBaleXMLFilename == nil then Logging.warning("Could not find bale for given bale type definition '%s'", baleTypeDef.index) end end end end function NetWrapAddon:onFillUnitFillLevelChanged(fillUnitIndex, fillLevelDelta, fillTypeIndex, toolType, fillPositionData, appliedDelta) if fillUnitIndex == self.spec_netWrapAddon.netWrapFillUnit then local spec = self.spec_netWrapAddon if self:getFillUnitFillLevel(spec.netWrapFillUnit) > 0 then if spec.netWrapRollVolume ~= nil then local scale = self:getFillUnitFillLevelPercentage(spec.netWrapFillUnit) + (1 - self:getFillUnitFillLevelPercentage(spec.netWrapFillUnit)) * 0.32 setScale(spec.netWrapRollVolume, 1, scale, scale) setVisibility(spec.netWrapBalerRoll, true) if spec.balerScroll ~= nil then setVisibility(spec.balerScroll, true) end end else if spec.netWrapRollVolume ~= nil then setScale(spec.netWrapRollVolume, 1, 0, 0) setVisibility(spec.netWrapBalerRoll, false) if spec.balerScroll ~= nil then setVisibility(spec.balerScroll, false) end end end elseif fillUnitIndex == self.spec_netWrapAddon.storageFillUnit then local spec = self.spec_netWrapAddon for i = 1, #spec.netWrapRoll.storageNode do if self:getFillUnitFillLevel(spec.storageFillUnit) / spec.rollLength >= i then setVisibility(spec.netWrapRoll.storageNode[i], true) else setVisibility(spec.netWrapRoll.storageNode[i], false) end end end end function NetWrapAddon:updateDebugValues(values) local spec = self.spec_netWrapAddon if self.configurations.netWrapAddon < 3 and spec.netWrapFillUnit > 0 then table.insert(values, {name = "isRoundBale", value = spec.isRoundBale}) local storageLength = 0 if spec.storageFillUnit > 0 then storageLength = self:getFillUnitCapacity(spec.storageFillUnit) / spec.rollStorage end table.insert(values, {name = "netWrapFillUnit", value = string.format("base %.0f lenght %.0f + storage %.0f lenght %.0f with %.0f rolls with color "..string.sub(g_fillTypeManager:getFillTypeNameByIndex(self:getFillUnitFillType(spec.netWrapFillUnit)), 0, -9), spec.netWrapFillUnit, spec.rollLength, spec.storageFillUnit, storageLength, spec.rollStorage)}) table.insert(values, {name = "bale", value = string.format("baleNetWrapTime %.4f - baleNetWrapUse %.4f - baleNetWrapUsed %.4f - diameter %.4f", spec.baleNetWrapTime, spec.baleNetWrapUse, spec.baleNetWrapUsed, self.spec_baler.baleTypes[self.spec_baler.currentBaleTypeIndex].diameter)}) table.insert(values, {name = "onDraw", value = string.format("showWarning %s - showAllowed %s - fillingAllowed %s - showPalletAllowed %s", spec.showWarning, spec.showAllowed, spec.fillingAllowed, spec.showPalletAllowed)}) end end function NetWrapAddon:setNetWrapAddon(designColor, noEventSend) local spec = self.spec_netWrapAddon spec.designColor = designColor NetWrapAddonEvent.sendEvent(self, designColor, noEventSend) end function NetWrapAddon:isUnloadingAllowed(superFunc) local spec = self.spec_baler if self.configurations.netWrapAddon < 3 and self.spec_netWrapAddon.netWrapFillUnit > 0 then if self.spec_netWrapAddon.baleNetWrapTime <= self.spec_netWrapAddon.baleNetWrapUse and self:getFillUnitFillLevelPercentage(self.spec_netWrapAddon.balerFillUnit) > 0.9999 then return false end end if (spec.platformReadyToDrop or spec.platformDropInProgress) and spec.unloadingState ~= Baler.UNLOADING_OPEN then return false end if self.spec_baleWrapper == nil then return not spec.allowsBaleUnloading or spec.allowsBaleUnloading and not self:getIsTurnedOn() and not spec.isBaleUnloading end return self:allowsGrabbingBale() end function NetWrapAddon:getFillLevelInformation(superFunc, display) superFunc(self, display) local spec = self.spec_fillUnit for i = 1, #spec.fillUnits do local fillUnit = spec.fillUnits[i] if fillUnit.fillLevel == 0 and fillUnit.showOnHud and fillUnit.supportedFillTypes[FillType.NETWRAP] then display:addFillLevel(FillType.NETWRAP, 0, fillUnit.capacity) end end end function NetWrapAddon:BaleManager_getBaleIndex(superfunc, fillTypeIndex, isRoundbale, width, height, length, diameter, customEnvironment) if customEnvironment ~= nil and customEnvironment ~= "" then if g_modIsLoaded.FS22_MaizePlus then for baleIndex = 1, #self.bales do local bale = self.bales[baleIndex] if bale.isAvailable and (bale.xmlFilename:contains("FS22_netWrap_addon") or bale.xmlFilename:contains("FS22_twine_addon")) and bale.xmlFilename:contains("FS22_MaizePlus") and string.lower(bale.xmlFilename):contains(customEnvironment) and self:getIsBaleMatching(bale, fillTypeIndex, isRoundbale, width, height, length, diameter) then return baleIndex end end end for baleIndex = 1, #self.bales do local bale = self.bales[baleIndex] if bale.isAvailable and (bale.xmlFilename:contains("FS22_netWrap_addon") or bale.xmlFilename:contains("FS22_twine_addon")) and not bale.xmlFilename:contains("FS22_MaizePlus") and string.lower(bale.xmlFilename):contains(customEnvironment) and self:getIsBaleMatching(bale, fillTypeIndex, isRoundbale, width, height, length, diameter) then return baleIndex end end end if customEnvironment ~= nil then for baleIndex = 1, #self.bales do local bale = self.bales[baleIndex] if bale.isAvailable and customEnvironment == bale.customEnvironment and self:getIsBaleMatching(bale, fillTypeIndex, isRoundbale, width, height, length, diameter) then return baleIndex end end end for baleIndex = 1, #self.bales do local bale = self.bales[baleIndex] if bale.isAvailable and bale.customEnvironment == nil and self:getIsBaleMatching(bale, fillTypeIndex, isRoundbale, width, height, length, diameter) then return baleIndex end end return nil end function NetWrapAddon:Bale_loadFromConfigXML(superfunc, xmlFilename, x, y, z, rx, ry, rz) if xmlFilename == nil or not fileExists(xmlFilename) then return false end local xmlFile = XMLFile.load("TempBale", xmlFilename, BaleManager.baleXMLSchema) self.xmlFilename = xmlFilename self.customEnvironment, self.baseDirectory = Utils.getModNameAndBaseDirectory(self.xmlFilename) self.i3dFilename = xmlFile:getValue("bale.filename") if self.xmlFilename:contains("FS22_netWrap_addon") and fileExists(Utils.getFilename(string.format(string.sub(self.i3dFilename, 0, -5).."_rounded.i3d"), self.baseDirectory)) then self.i3dFilename = string.format(string.sub(self.i3dFilename, 0, -5).."_rounded.i3d") Logging.devInfo("%s: load bales for the mod FS22_RounderWrappedRoundBales with i3dFilename '%s' ", modName, self.i3dFilename) end if self.i3dFilename ~= nil then self.i3dFilename = Utils.getFilename(self.i3dFilename, self.baseDirectory) self:createNode(self.i3dFilename) if x ~= nil and y ~= nil and z ~= nil and ry ~= nil and ry ~= nil and rz ~= nil then setTranslation(self.nodeId, x, y, z) setRotation(self.nodeId, rx, ry, rz) end if not self:loadBaleAttributesFromXML(xmlFile) then return false end end xmlFile:delete() g_currentMission.itemSystem:addItemToSave(self) self:setBaleAIObstacle(true) return true end function NetWrapAddon.Bale_setFillTypeTexturesForNode(nodeId, fillTypeInfo) if getHasClassId(nodeId, ClassIds.SHAPE) then local materialId = getMaterial(nodeId, 0) if materialId ~= 0 then local shaderFilename = getMaterialCustomShaderFilename(materialId) if shaderFilename:contains("silageBaleExtensionShader") then local oldWrappingState, _, _, _ = getShaderParameter(nodeId, "wrappingState") local oldWrapR, oldWrapG, oldWrapB, oldWrapA = getShaderParameter(nodeId, "colorScale") setShaderParameter(nodeId, "wrappingState", oldWrappingState, 0, 0, 0, false) setShaderParameter(nodeId, "colorScale", oldWrapR, oldWrapG, oldWrapB, oldWrapA, false) end end end end function NetWrapAddon.BaleManager_loadMapData(self, superfunc, xmlFile, missionInfo, baseDirectory) local returnValue = superfunc(self, xmlFile, missionInfo, baseDirectory) local modBales = XMLFile.load("modDesc", modDirectory.."xmlFilename/mod_bales.xml") local mapDirectory = g_mpLoadingScreen.missionInfo.map.baseDirectory if mapDirectory ~= "" and not fileExists(mapDirectory.."dlcDesc.xml") then local mapXmlFile = XMLFile.load("modDesc", mapDirectory.."modDesc.xml") if mapXmlFile:hasProperty("modDesc.terraLife") then modBales:iterate("modDesc.bales.FS22_TerraLifePlus_Assets.bale", function (index, key) g_baleManager:loadBaleFromXML(modBales, key, modDirectory) end) Logging.devInfo("%s: load bales for the mod '%s' ", modName, "FS22_TerraLifePlus_Assets") Bale.loadFromConfigXML = Utils.overwrittenFunction(Bale.loadFromConfigXML, NetWrapAddon.Bale_loadFromConfigXML) else modBales:iterate("modDesc.bales.bale", function (index, key) g_baleManager:loadBaleFromXML(modBales, key, modDirectory) end) if g_modIsLoaded.FS22_MaizePlus then modBales:iterate("modDesc.bales.FS22_MaizePlus.bale", function (index, key) g_baleManager:loadBaleFromXML(modBales, key, modDirectory) end) Logging.devInfo("%s: load bales for the mod '%s' ", modName, "FS22_MaizePlus") end if g_modIsLoaded.FS22_cornProductionPack then modBales:iterate("modDesc.bales.FS22_cornProductionPack.bale", function (index, key) g_baleManager:loadBaleFromXML(modBales, key, modDirectory) end) Logging.devInfo("%s: load bales for the mod '%s' ", modName, "FS22_cornProductionPack") end for name, loaded in pairs(g_modIsLoaded) do if loaded then if not g_modManager:isModMap(name) then local i = 0 while true do local modBale = string.format("modDesc.bales.balers.bale(%d)", i) if not modBales:hasProperty(modBale) then break end local filename = modBales:getString(modBale.."#filename") if filename:contains(name) then g_baleManager:loadBaleFromXML(modBales, modBale, modDirectory) Logging.devInfo("%s: load bales for the mod '%s' with filename '%s'", modName, name, filename) end i = i + 1 end else local i = 0 while true do local modBale = string.format("modDesc.bales.maps.bale(%d)", i) if not modBales:hasProperty(modBale) then break end local filename = modBales:getString(modBale.."#filename") if filename:contains(name) then g_baleManager:loadBaleFromXML(modBales, modBale, modDirectory) Logging.devInfo("%s: load bales for the map '%s' with filename '%s'", modName, name, filename) end i = i + 1 end end end end if g_modIsLoaded.FS22_RounderWrappedRoundBales then Bale.loadFromConfigXML = Utils.overwrittenFunction(Bale.loadFromConfigXML, NetWrapAddon.Bale_loadFromConfigXML) end end mapXmlFile:delete() else modBales:iterate("modDesc.bales.bale", function (index, key) g_baleManager:loadBaleFromXML(modBales, key, modDirectory) end) if g_modIsLoaded.FS22_MaizePlus then modBales:iterate("modDesc.bales.FS22_MaizePlus.bale", function (index, key) g_baleManager:loadBaleFromXML(modBales, key, modDirectory) end) Logging.devInfo("%s: load bales for the mod '%s' ", modName, "FS22_MaizePlus") end if g_modIsLoaded.FS22_cornProductionPack then modBales:iterate("modDesc.bales.FS22_cornProductionPack.bale", function (index, key) g_baleManager:loadBaleFromXML(modBales, key, modDirectory) end) Logging.devInfo("%s: load bales for the mod '%s' ", modName, "FS22_cornProductionPack") end for name, loaded in pairs(g_modIsLoaded) do if loaded then if not g_modManager:isModMap(name) then local i = 0 while true do local modBale = string.format("modDesc.bales.balers.bale(%d)", i) if not modBales:hasProperty(modBale) then break end local filename = modBales:getString(modBale.."#filename") if filename:contains(name) then g_baleManager:loadBaleFromXML(modBales, modBale, modDirectory) Logging.devInfo("%s: load bales for the mod '%s' with filename '%s'", modName, name, filename) end i = i + 1 end else local i = 0 while true do local modBale = string.format("modDesc.bales.maps.bale(%d)", i) if not modBales:hasProperty(modBale) then break end local filename = modBales:getString(modBale.."#filename") if filename:contains(name) then g_baleManager:loadBaleFromXML(modBales, modBale, modDirectory) Logging.devInfo("%s: load bales for the map '%s' with filename '%s'", modName, name, filename) end i = i + 1 end end end end if g_modIsLoaded.FS22_RounderWrappedRoundBales then Bale.loadFromConfigXML = Utils.overwrittenFunction(Bale.loadFromConfigXML, NetWrapAddon.Bale_loadFromConfigXML) end end modBales:delete() return returnValue end function getConfigurationsFromXML(xmlFile, superfunc, key, baseDir, customEnvironment, isMod, storeItem) local configurations, defaultConfigurationIds = superfunc(xmlFile, key, baseDir, customEnvironment, isMod, storeItem) if configurations == nil then configurations = {} end if defaultConfigurationIds == nil then defaultConfigurationIds = {} end if xmlFile:hasProperty("vehicle.baler") and xmlFile:hasProperty("vehicle.fillUnit") and xmlFile:getValue("vehicle.baler.baleTypes.baleType(0)#isRoundBale", false) then configurations["netWrapAddon"] = { { isDefault = false, saveId = "1", isSelectable = true, index = 1, dailyUpkeep = 0, price = 0, name = g_i18n:getText("configuration_activate"), nameCompareParams = {} }, { isDefault = false, saveId = "2", isSelectable = true, index = 2, dailyUpkeep = 0, price = 0, name = g_i18n:getText("configuration_activateStorage"), nameCompareParams = {} }, { isDefault = false, saveId = "3", isSelectable = true, index = 3, dailyUpkeep = 0, price = 0, name = g_i18n:getText("configuration_valueNo"), nameCompareParams = {} } } if configurations["refillSupplies"] ~= nil then for i = 1, #configurations["refillSupplies"] do configurations["refillSupplies"][i].isSelectable = false end end end return configurations, defaultConfigurationIds end function NetWrapAddon.replaceCollisionMask(node, collisionMask) if getHasClassId(node, ClassIds.SHAPE) then local mask = getCollisionMask(node) if mask == 8194 then setCollisionMask(node, collisionMask) end end local numChildren = getNumOfChildren(node) if numChildren > 0 then for i = 0, numChildren - 1 do NetWrapAddon.replaceCollisionMask(getChildAt(node, i), collisionMask) end end end function NetWrapAddon:FarmStats_saveToXMLFile(xmlFile, key) xmlFile:setFloat(key..".statistics.netWrapUsage", self.statistics.netWrapUsage.total) end function NetWrapAddon:FarmStats_loadFromXMLFile(xmlFile, rootKey) local key = rootKey..".statistics" self.statistics.netWrapUsage.total = xmlFile:getFloat(key..".netWrapUsage", 0) end function NetWrapAddon:FarmStats_getStatisticData(superFunc) if superFunc ~= nil then superFunc(self) end if not g_currentMission.missionDynamicInfo.isMultiplayer or not g_currentMission.missionDynamicInfo.isClient then self:addStatistic("netWrapUsage", g_i18n:getText("unit_mShort"), g_i18n:getFluid(self:getSessionValue("netWrapUsage")), g_i18n:getFluid(self:getTotalValue("netWrapUsage")), "%.0f") self.statisticDataRev["netWrapUsage"].name = g_i18n:getText("statistic_netWrapUsage", modName).." ["..g_i18n:getText("unit_mShort").."]" end return Utils.getNoNil(self.statisticData, {}) end function NetWrapAddon.FSBaseMission_loadMap() local xmlFile = XMLFile.load("ModFile", modDirectory.."modDesc.xml") local name = xmlFile:getString("modDesc.storePack#name") local i = 0 while true do local storeItem = string.format("modDesc.storeItems.storeItem(%d)", i) if not xmlFile:hasProperty(storeItem) then break end local xmlFilename = xmlFile:getString(storeItem.."#xmlFilename") xmlFilename = string.sub(xmlFilename, 6, string.len(xmlFilename)) for item = 1, #g_storeManager.items do if string.match(g_storeManager.items[item].xmlFilename, xmlFilename) and not string.match(g_storeManager.items[item].xmlFilename, "netWrap") then table.insert(g_storeManager.packs[name].items, g_storeManager.items[item].xmlFilename) end end i = i + 1 end xmlFile:delete() FarmStats.saveToXMLFile = Utils.appendedFunction(FarmStats.saveToXMLFile, NetWrapAddon.FarmStats_saveToXMLFile) FarmStats.loadFromXMLFile = Utils.appendedFunction(FarmStats.loadFromXMLFile, NetWrapAddon.FarmStats_loadFromXMLFile) FarmStats.getStatisticData = Utils.overwrittenFunction(FarmStats.getStatisticData, NetWrapAddon.FarmStats_getStatisticData) end function NetWrapAddon.init() local xmlFile = XMLFile.load("ModFile", modDirectory.."modDesc.xml") local key = string.format("modDesc.storePack") local name = xmlFile:getString(key.."#name") local title = xmlFile:getString(key.."#title") local imageFilename = string.format(modDirectory..xmlFile:getString(key.."#image")) if title ~= nil and title:sub(1, 6) == "$l10n_" then title = g_i18n:getText(title:sub(7), modName) end g_storeManager:addPack(name, title, imageFilename, "") xmlFile:delete() Logging.info("Mod: '%s' Added store pack with name = '%s'", modName, name) FillTypeManager.SEND_NUM_BITS = FillTypeManager.SEND_NUM_BITS + 1 Logging.info("Mod: '%s' Updated limit of fill type to = '%s'", modName, FillTypeManager.SEND_NUM_BITS * 32) FSBaseMission.loadMap = Utils.prependedFunction(FSBaseMission.loadMap, NetWrapAddon.FSBaseMission_loadMap) BaleManager.getBaleIndex = Utils.overwrittenFunction(BaleManager.getBaleIndex, NetWrapAddon.BaleManager_getBaleIndex) Bale.setFillTypeTexturesForNode = Utils.appendedFunction(Bale.setFillTypeTexturesForNode, NetWrapAddon.Bale_setFillTypeTexturesForNode) BaleManager.loadMapData = Utils.overwrittenFunction(BaleManager.loadMapData, NetWrapAddon.BaleManager_loadMapData) table.insert(FarmStats.STAT_NAMES, "netWrapUsage") Logging.info("Mod: '%s' Added farm stat with name = '%s'", modName, g_i18n:getText("statistic_netWrapUsage", modName)) MoneyType.PURCHASE_NETWRAP = MoneyType.register("purchaseNetWrap", "finance_purchaseNetWrap", modName) end NetWrapAddon.init() NetWrapAddonEvent = {} local NetWrapAddonEvent_mt = Class(NetWrapAddonEvent, Event) InitEventClass(NetWrapAddonEvent, "NetWrapAddonEvent") function NetWrapAddonEvent.emptyNew() return Event.new(NetWrapAddonEvent_mt) end function NetWrapAddonEvent.new(vehicle, designColor) local self = NetWrapAddonEvent.emptyNew() self.vehicle = vehicle self.designColor = designColor return self end function NetWrapAddonEvent:readStream(streamId, connection) self.vehicle = NetworkUtil.readNodeObject(streamId) self.designColor = streamReadBool(streamId) self:run(connection) end function NetWrapAddonEvent:writeStream(streamId, connection) NetworkUtil.writeNodeObject(streamId, self.vehicle) streamWriteBool(streamId, self.designColor) end function NetWrapAddonEvent:run(connection) if not connection:getIsServer() then g_server:broadcastEvent(self, false, connection, self.vehicle) end if self.vehicle ~= nil and self.vehicle:getIsSynchronized() then self.vehicle:setNetWrapAddon(self.designColor, true) end end function NetWrapAddonEvent.sendEvent(vehicle, designColor, noEventSend) if noEventSend == nil or noEventSend == false then if g_server ~= nil then g_server:broadcastEvent(NetWrapAddonEvent.new(vehicle, designColor), nil, nil, vehicle) else g_client:getServerConnection():sendEvent(NetWrapAddonEvent.new(vehicle, designColor)) end end end FSMissionInfo.helperBuyNetWrap = false local function loadMap(self) local missionInfo = g_currentMission.missionInfo if missionInfo ~= nil and missionInfo.savegameDirectory ~= nil then local careerSavegame = loadXMLFile("careerXML", missionInfo.savegameDirectory.."/careerSavegame.xml") if careerSavegame ~= nil then missionInfo.helperBuyNetWrap = Utils.getNoNil(getXMLBool(careerSavegame, missionInfo.xmlKey..".settings.helperBuyNetWrap"), false) delete(careerSavegame) end end end FSBaseMission.loadMap = Utils.appendedFunction(FSBaseMission.loadMap, loadMap) local function onStartMission(self) if self.missionInfo ~= nil then Logging.devInfo("%s: use the savegame setting for the 'helperBuyNetWrap' => '%s' ", modName, self.missionInfo.helperBuyNetWrap) end end FSBaseMission.onStartMission = Utils.appendedFunction(FSBaseMission.onStartMission, onStartMission) local function saveToXMLFile(self) if self.isValid then setXMLBool(self.xmlFile, self.xmlKey..".settings.helperBuyNetWrap", self.helperBuyNetWrap) end end FSCareerMissionInfo.saveToXMLFile = Utils.appendedFunction(FSCareerMissionInfo.saveToXMLFile, saveToXMLFile) local settingsAdded = false local function onFrameOpen(self, superFunc, element) superFunc(self, element) if not settingsAdded then local indexElement = 1 for i = 1, #self.boxLayout.elements do if self.boxLayout.elements[i] == self.checkHelperRefillSeed then indexElement = i break end end local checkHelperRefillNetWrap = self.checkHelperRefillSeed:clone(self.boxLayout) checkHelperRefillNetWrap.elements[4]:setText(self.l10n:getText("setting_helperBuyNetWrap", modName)) checkHelperRefillNetWrap.elements[6]:setText(self.l10n:getText("toolTip_helperBuyNetWrap", modName)) checkHelperRefillNetWrap.texts[2] = self.l10n:getText(InGameMenuGameSettingsFrame.L10N_SYMBOL.BUY) self.boxLayout:removeElement(checkHelperRefillNetWrap) function checkHelperRefillNetWrap.onClickCallback(_, ...) self:onClickHelperRefillNetWrap(...) end checkHelperRefillNetWrap:setIsChecked(self.missionInfo.helperBuyNetWrap) table.insert(self.boxLayout.elements, indexElement, checkHelperRefillNetWrap) checkHelperRefillNetWrap.parent = self.boxLayout self.boxLayout:invalidateLayout() settingsAdded = true end end InGameMenuGameSettingsFrame.onFrameOpen = Utils.overwrittenFunction(InGameMenuGameSettingsFrame.onFrameOpen, onFrameOpen) InGameMenuGameSettingsFrame.onClickHelperRefillNetWrap = function (self, state) if self.hasMasterRights then state = state == CheckedOptionElement.STATE_CHECKED if self.missionInfo ~= nil and self.missionInfo.helperBuyNetWrap ~= state then self.missionInfo.helperBuyNetWrap = state Logging.devInfo("%s: setting for the 'helperBuyNetWrap' change to => '%s' ", modName, state) end end end