--[[
SugarBeetHarvesterPotatoReady

Specialization to allow harvest potato with the sugarBeet harvester vehicles

Author: 	Ifko[nator]
Date: 		22.09.2022
Version:	1.2

History:	v1.0 @04.01.2022 - initial implemation in FS 22
			------------------------------------------------------
			v1.1 @21.04.2022 - fix bug with sugar cane harevesters
							 - fix for patch 1.4 and higher
			------------------------------------------------------
			v1.2 @22.09.2022 - script works again in multiplayer
]]

SugarBeetHarvesterPotatoReady = {};

function SugarBeetHarvesterPotatoReady.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(FillUnit, specializations) or SpecializationUtil.hasSpecialization(FruitPreparer, specializations);
end;

function SugarBeetHarvesterPotatoReady.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad",	
		"onUpdateTick",
		"onWriteStream",
		"onReadStream",
		"onWriteUpdateStream",
		"onReadUpdateStream"
	};

	for _, functionName in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, functionName, SugarBeetHarvesterPotatoReady);
	end;
end;

function SugarBeetHarvesterPotatoReady:onLoad(savegame)
	local specFillUnit = self.spec_fillUnit;
	local specCutter = self.spec_cutter;

	self.isSugarCaneHarevester = false;
	
	if specCutter ~= nil then
		if specCutter.fruitTypes ~= nil then
			local fruitType = "POTATO";
			
			if FruitType[fruitType] ~= nil then
				local fruitTypes = "";
				
				for _, fruitType in pairs(specCutter.fruitTypes) do
					if fruitTypes == "" then
						fruitTypes = g_fruitTypeManager:getFruitTypeByIndex(fruitType).name;
					else
						fruitTypes = fruitTypes .. ", " .. g_fruitTypeManager:getFruitTypeByIndex(fruitType).name;
					end;
				end;

				if string.find(fruitTypes, "SUGARBEET") and not string.find(fruitTypes, fruitType) then
					table.insert(specCutter.fruitTypes, FruitType[fruitType]);
				end;
			end;
		end;

		local specFruitPreparer = self.spec_fruitPreparer;

		if specFruitPreparer ~= nil then
			specFruitPreparer.time = 1;

			self.isSugarCaneHarevester = specFruitPreparer.fruitType == g_fruitTypeManager:getFruitTypeByName("sugarCane").index;
		end;
	end;

	if specFillUnit ~= nil then
		specFillUnit.xmlFile = loadXMLFile("vehicle", self.xmlFile.filename);

		local fillUnitConfigurationId = Utils.getNoNil(self.configurations["fillUnit"], 1);
		local baseKey = string.format("vehicle.fillUnit.fillUnitConfigurations.fillUnitConfiguration(%d).fillUnits", fillUnitConfigurationId - 1);
		
		local fillUnitNumber = 0;

    	while true do
			local fillUnitKey = string.format("%s.fillUnit(%d)", baseKey, fillUnitNumber);

			if not self.xmlFile:hasProperty(fillUnitKey) then
    	        break;
			end;

			local fillTypes = getXMLString(specFillUnit.xmlFile, fillUnitKey .. "#fillTypes");
		
			if fillTypes ~= nil then
				local fillType = "POTATO";

				if FillType[fillType] ~= nil then
					if specFillUnit.fillUnits[fillUnitNumber + 1].supportedFillTypes[FillType.SUGARBEET] and not specFillUnit.fillUnits[fillUnitNumber + 1].supportedFillTypes[FillType[fillType]] then
						specFillUnit.fillUnits[fillUnitNumber + 1].supportedFillTypes[FillType[fillType]] = true;
					end;
				end;
			end;

			fillUnitNumber = fillUnitNumber + 1;
		end;
	end;
end;

function SugarBeetHarvesterPotatoReady:onUpdateTick(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
	local specFruitPreparer = self.spec_fruitPreparer;

	if specFruitPreparer == nil or self.getCombine == nil then
		return;
	else
		local combine = self:getCombine();

		if combine ~= nil and combine:getIsTurnedOn() and not self.isSugarCaneHarevester then		
			local specCutter = self.spec_cutter;
			local specFillUnit = combine.spec_fillUnit;
			local specCombine = combine.spec_combine;

			if specFillUnit.fillUnits ~= nil then	
				for _, fillUnit in pairs(specFillUnit.fillUnits) do
					if fillUnit.fillLevel == 0 then
						if specFruitPreparer.time < 2 then
							--## dirty hack to switch the fruit type
							specFruitPreparer.time = specFruitPreparer.time + 1;
						else
							specFruitPreparer.time = 1;
						end;

						local currentFruit = nil;

						if specFruitPreparer.time == 1 then
							currentFruit = g_fruitTypeManager:getFruitTypeByName("sugarBeet");
						elseif specFruitPreparer.time == 2 then
							currentFruit = g_fruitTypeManager:getFruitTypeByName("potato");
						end;

						if currentFruit ~= nil then
							specFruitPreparer.fruitType = currentFruit.index;

							if self.setAIFruitRequirements ~= nil then
               					self:setAIFruitRequirements(currentFruit.index, currentFruit.minPreparingGrowthState, currentFruit.maxPreparingGrowthState);

								local aiUsePreparedState = Utils.getNoNil(getXMLBool(specFillUnit.xmlFile, "vehicle.fruitPreparer#aiUsePreparedState"), specCutter ~= nil);

								if aiUsePreparedState then
               					    self:addAIFruitRequirement(currentFruit.index, currentFruit.preparedGrowthState, currentFruit.preparedGrowthState);
               					end;
							end;

							combine.fruitPreparerFruitType = currentFruit.index;
						end;
					elseif specFruitPreparer.currentInputFruitType ~= specFruitPreparer.fruitType then	
						local currentFruitType = specFruitPreparer.currentInputFruitType;

						if combine ~= nil then	
							currentFruitType = g_fruitTypeManager:getFruitTypeByName(g_fillTypeManager:getFillTypeByIndex(fillUnit.fillType).name);
						end;

						if currentFruitType ~= nil then
							specFruitPreparer.fruitType = currentFruitType.index;

							if self.setAIFruitRequirements ~= nil then
               					self:setAIFruitRequirements(currentFruitType.index, currentFruitType.minPreparingGrowthState, currentFruitType.maxPreparingGrowthState);

								local aiUsePreparedState = Utils.getNoNil(getXMLBool(specFillUnit.xmlFile, "vehicle.fruitPreparer#aiUsePreparedState"), specCutter ~= nil);

								if aiUsePreparedState then
               					    self:addAIFruitRequirement(currentFruitType.index, currentFruitType.preparedGrowthState, currentFruitType.preparedGrowthState);
               					end;
							end;

							combine.fruitPreparerFruitType = currentFruitType.index;

							specFruitPreparer.currentInputFruitType = specFruitPreparer.fruitType;
						end;
					end;
				end;
			end;
		end;
	end;
end;

function SugarBeetHarvesterPotatoReady:onWriteStream(streamId, connection)
    if not connection:getIsServer() then 
		local specFruitPreparer = self.spec_fruitPreparer;

		if specFruitPreparer ~= nil then
			streamWriteIntN(streamId, specFruitPreparer.time, 3);
		end;
	end;
end;

function SugarBeetHarvesterPotatoReady:onReadStream(streamId, connection)
    if connection:getIsServer() then
		local specFruitPreparer = self.spec_fruitPreparer;

		if specFruitPreparer ~= nil then
			specFruitPreparer.time = streamReadIntN(streamId, 3);
		end;
	end;
end;

function SugarBeetHarvesterPotatoReady:onWriteUpdateStream(streamId, connection, dirtyMask)
    if not connection:getIsServer() then 
		local specFruitPreparer = self.spec_fruitPreparer;

		if specFruitPreparer ~= nil then
			streamWriteIntN(streamId, specFruitPreparer.time, 3);
		end;
	end;
end;

function SugarBeetHarvesterPotatoReady:onReadUpdateStream(streamId, timestamp, connection)
    if connection:getIsServer() then
		local specFruitPreparer = self.spec_fruitPreparer;

		if specFruitPreparer ~= nil then
			specFruitPreparer.time = streamReadIntN(streamId, 3);
		end;
	end;
end;

--## add potato icon in the shop view
function SugarBeetHarvesterPotatoReady:assignItemAttributeData(displayItem)
	local function foundFillTypeInTable(fillTypeTable, fillType)
		for fillTypeNumber = 1, #fillTypeTable do
			if string.find(fillTypeTable[fillTypeNumber], fillType) then
				return true;
			end;
		end;
		
		return false;
	end;

	local foundSugarBeet = foundFillTypeInTable(displayItem.fillTypeIconFilenames, "sugarBeet");
	local foundPotato = foundFillTypeInTable(displayItem.fillTypeIconFilenames, "potato");
	
	if foundSugarBeet and not foundPotato then
		--## add potato icon to the shop overview, if not already added
		table.insert(displayItem.fillTypeIconFilenames, "dataS/menu/hud/fillTypes/hud_fill_potato.png");
	end;
end;

ShopItemsFrame.assignItemAttributeData = Utils.prependedFunction(ShopItemsFrame.assignItemAttributeData, SugarBeetHarvesterPotatoReady.assignItemAttributeData);